/**

 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml.modifications

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ReactionEffect
import com.yakindu.sct.model.sgraph.Exit
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.sgraph.Vertex
import com.yakindu.sct.model.sgraph.util.SgraphExtensions
import com.yakindu.sct.model.stext.concepts.ExitTransition
import com.yakindu.sct.model.stext.stext.ExitPointSpec
import java.util.Set

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class ExitPointModification implements IModification {

	@Inject
	protected extension SgraphExtensions
	@Inject
	protected extension ExitTransition

	override modify(Statechart statechart) {
		val transitions = statechart.eAllContents.filter(Transition).filter[it.target instanceof Exit].toList
		val deleteMe = newHashSet()
		transitions.forEach[modify(deleteMe)]
		deleteMe.forEach[remove]
	}

	def protected modify(Transition transition, Set<Transition> exitTransitions) {
		val exit = transition.target as Exit
		val realName = if(exit.name.empty) 'default' else exit.name

		val outTransitions = (exit.parentRegion.composite as Vertex).outgoingTransitions
		var exitTrans = outTransitions.filter(t|t.trigger === null && t.hasExitPoint(realName)).head
		if(exitTrans === null) exitTrans = outTransitions.filter( t |
			t.trigger === null && t.exitPointName.equals('default')
		).head
		if (exitTrans !== null) {
			transition.target = exitTrans.target
			exitTransitions.add(exitTrans)

			val effect = exitTrans.effect as ReactionEffect
			if (effect !== null) {
				val targetEffect = (transition.effect as ReactionEffect)
				if (targetEffect === null)
					transition.effect = effect
				else
					targetEffect.actions += effect.actions
			}

		}
	}

	def hasExitPoint(Transition t, String name) {
		! t.properties.filter(typeof(ExitPointSpec)).filter[exitpoint == name].isEmpty
	}

}
