/**

 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Robert Rudi - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml.modifications

import com.yakindu.base.expressions.expressions.ReactionTrigger
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.Transition

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

/**
 * @author robert rudi - Initial contribution and API
 */
class TransitionMultipleEventModification implements IModification {
	override void modify(Statechart statechart) {
		statechart.eAllContents.filter(Transition).filter[splitNeeded].forEach[split]
	}

	def void split(Transition it) {
		reactionTrigger.triggers.forEach [ tr |
			val transition = copy
			transition.source = it.source
			transition.target = it.target

			transition.reactionTrigger.triggers.clear
			transition.reactionTrigger.triggers.add(tr.copy)
		]

		delete
	}

	def ReactionTrigger reactionTrigger(Transition it) {
		switch (it.trigger) {
			case null: null
			ReactionTrigger: it.trigger as ReactionTrigger
			default: null
		}
	}

	def splitNeeded(Transition it) {
		if (reactionTrigger !== null && reactionTrigger.triggers.size > 1)
			return true
		return false
	}
}
