/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sctunit.simulation.scxml

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.sct.domain.scxml.simulation.SCXMLSimulationEngine
import com.yakindu.sct.domain.scxml.simulation.SCXMLSimulationEngineFactory
import com.yakindu.sct.model.sgraph.FinalState
import com.yakindu.sct.model.sruntime.ExecutionEvent
import com.yakindu.sctunit.sCTUnit.EnterExpression
import com.yakindu.sctunit.sCTUnit.ExitExpression
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.StatechartActiveExpression
import com.yakindu.sctunit.sCTUnit.StatechartFinalExpression
import com.yakindu.sctunit.simulation.core.interpreter.BaseSCTUnitTestCaseInterpreter
import org.eclipse.debug.core.ILaunch

import static com.yakindu.base.expressions.interpreter.SlotResolutionExceptionSupplier.*

/** 
 * @author andreas muelder - Initial contribution and API
 */
class SCXMLSCTUnitTestCaseInterpreter extends BaseSCTUnitTestCaseInterpreter {

	@Inject SCXMLSimulationEngineFactory engineFactory
	@Inject(optional=true) ILaunch launch

	SCXMLSimulationEngine engine

	override void init(SCTUnitClass unitClass) {
		engine = engineFactory.createExecutionContainer(unitClass.getStatechart(), launch) as SCXMLSimulationEngine
		engine.init()
		engine.externalTimeControl = true
		context = engine.getExecutionContext()
		super.init(unitClass)

	}

	def dispatch execute(EnterExpression stm) {
		engine.start()
		engine.timeTaskScheduler.suspend
		return null
	}

	def dispatch execute(StatechartFinalExpression it) {
		if (!context.activeStates.nullOrEmpty)
			return context.activeStates.forall[state|state instanceof FinalState]
		return false
	}

	def dispatch execute(StatechartActiveExpression it) {
		return !context.allActiveStates.nullOrEmpty
	}

	def dispatch Object execute(ExitExpression stm) {
		engine.terminate();
		return null;
	}

	override protected Object _execute(EventRaisingExpression eventRaising) {
		var event = (resolver.resolve(context, eventRaising.getEvent()).orElseThrow(
			forContext(eventRaising.getEvent())) as ExecutionEvent)
		var Object value = if(eventRaising.getValue() !== null) super.execute(eventRaising.getValue()) else null
		event.setValue(value)
		event.setRaised(true)
		return null
	}

}
