/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.itemis.create.statechart.generator.csharp.codepattern.CsharpStatemachineExpressionCode
import com.yakindu.base.types.Operation
import com.yakindu.sct.generator.core.templates.SexecGenerator
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.generator.core.codemodel.StatemachineClass

/**
 * @author axel terfloth
 */
class CsharpInternalFunctions{
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension StatemachineClass
	@Inject protected extension SExecExtensions
	@Inject protected extension SexecGenerator
	@Inject protected extension EventProcessing
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension INamingService
	@Inject protected extension CsharpVisibility
	@Inject protected extension CsharpStatemachineExpressionCode
	@Inject protected extension Documentation
	@Inject protected extension Literals
	
	def functionImplementations(ExecutionFlow it) '''
		// implementations of all internal functions
		«checkFunctions.toImplementation»
		«effectFunctions.toImplementation»
		«entryActionFunctions.toImplementation»
		«exitActionFunctions.toImplementation»
		«enterSequenceFunctions.toImplementation»
		«exitSequenceFunctions.toImplementation»
		«reactFunctions.filter[ f | ! (f.eContainer instanceof ExecutionState)].toList.toImplementation»
		«reactMethods.filter(Operation).toDefinitions»
		«methods.filter(Operation).filter[m | !#[it.swapIncomingEvents, it.clearInEvents, it.swapInternalEvents, it.clearInternalEvents, it.clearCurrentInEvents].contains(m)].toDefinitions»
		«features.filter(Operation).filter[m | !(m instanceof Method)].toDefinitions»
	'''
	
	def toDefinitions(Iterable<Operation> methods){'''
			«FOR m : methods»
				«implementation(m)»
				
			«ENDFOR»
		'''}
		
	def toMethodDefinitions(Iterable<Method> methods){'''
			«FOR m : methods»
				«implementation(m)»
				
			«ENDFOR»
		'''}
		
	 
	 def dispatch implementation(Method it) '''
		«methodModifier» «typeSpecifier.targetLanguageName» «IF eContainer.isStatemachineClass»«name»«ELSE»«shortName.toFirstUpper»«ENDIF»(«FOR p : parameters SEPARATOR ', '» «p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDFOR») {
			«body.code»
		}
	''' 
	 
	 def dispatch implementation(Operation it) '''
		/* «documentation» */
		«methodModifier» «typeSpecifier.targetLanguageName» «name.toFirstUpper»(«FOR p : parameters SEPARATOR ', '»«p.typeSpecifier.asLiteral» «p.name.asIdentifier»«ENDFOR») «implementation.code»
	'''
	 
	def toImplementation(Iterable<Step> steps) '''
		«FOR s : steps»
			«s.functionImplementation»
		«ENDFOR»
	'''
	
	def dispatch functionImplementation(Check it) '''
		«stepComment»
		private bool «shortName»()
		{
			return «code»;
		}
		
	'''
	
	def dispatch functionImplementation(Step it) '''
		«stepComment»
		private void «shortName.toFirstUpper»()
		{
			«code»
		}
		
	'''
	
	protected def methodModifier(Operation it) {
		if (isPublic)
			'''public'''
		else 
			'''private '''
	}
	
}
