/**
 * Copyright (c) 2022-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.concepts.TimedInterface
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpCompilationUnit
import com.itemis.create.base.generator.csharp.codemodel.CsharpNamespace
import com.itemis.create.base.generator.csharp.codemodel.CsharpStatemachineLibrary
import com.itemis.create.base.generator.csharp.codepattern.ClassCode
import com.itemis.create.base.generator.csharp.concepts.AsyncAwait
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.itemis.create.base.generator.csharp.transformation.EventBufferTransformation
import com.itemis.create.statechart.generator.csharp.transformation.ExecFlowConceptsTransformation
import com.itemis.create.statechart.generator.csharp.transformation.OutPropertyEventHandler
import com.yakindu.base.types.Package
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.codemodel.StateMetaInformation
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.codemodel.StatemachineFunctions
import com.yakindu.sct.generator.core.codemodel.StatemachineProperties
import com.yakindu.sct.generator.core.extensions.ICodeModel
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.concepts.SubMachine
import com.yakindu.sct.model.sexec.concepts.TriggerWithoutEventMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import org.eclipse.xtext.EcoreUtil2
import com.yakindu.sct.model.sexec.concepts.SubMachine.SubmachineTypeLibrary

/**
 * The code model is created from the executution flow and consist of type system based model elements.
 * These model elements represent concrete C++ implementation artifacts which represent different implementation
 * concepts 
 * 
 * @author axel terfloth
 * @author laszlo kovacs
 *
 */
@Singleton class CsharpStatemachineCodeModel implements ICodeModel{

	@Inject protected extension StateEnum
	@Inject protected extension StatemachineProperties
	@Inject protected extension CsharpStatemachineMembers
	@Inject protected extension CsharpStatemachineOperationCallbacks
	@Inject protected extension CsharpStatemachineEvents
	@Inject protected extension StateMetaInformation
	@Inject protected extension SExecExtensions
	@Inject protected extension CsharpStatemachineConstructor

	@Inject protected extension StatemachineClass
	@Inject protected extension CsharpNamedInterfaceClasses
	@Inject protected extension StatemachineFunctions
	@Inject protected extension EventBufferTransformation
	@Inject protected extension CsharpEventQueueImplementation
	@Inject protected extension CsharpInternalFunctions
	
	@Inject protected extension CsharpStatemachineLibrary
	@Inject protected extension Statechart2TypeTransformation
	
	@Inject protected extension CsharpCompilationUnit
	@Inject protected extension CsharpNamespace
	@Inject protected extension CsharpClass
	
	@Inject protected extension GeneratorAssignment
	@Inject protected extension CsharpGenmodelEntries
	@Inject protected extension ClassCode
	@Inject protected extension Documentation
	@Inject protected extension OriginTracing
	@Inject protected extension SubMachine
	@Inject protected extension SubmachineTypeLibrary
	
	@Inject protected extension TimedInterface
	
	@Inject protected extension EventQueue
	
	@Inject protected extension AsyncAwait
	@Inject protected extension ExecFlowConceptsTransformation
	@Inject protected extension TriggerWithoutEventMethod
	@Inject protected extension OutPropertyEventHandler
	
	@Inject protected GeneratorEntry entry
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	

	def create cu : _compilationUnit implementationClassCompilationUnit(ExecutionFlow it) {
		
		val implClass = implementationClass
		
		cu.name = implClass.name
		
		val topLevelNamespace = EcoreUtil2.getAllContainers(implClass).filter(Package).findLast[isNamespace]
		
		if (topLevelNamespace !== null) {
			cu.member += topLevelNamespace
		} else {
			cu.member += implClass
		}
	}
	
	override defineImplementationClass(ExecutionFlow it) {
		it.implementationClass
	}
	
	
	def create i : flow.stateMachineClass implementationClass(ExecutionFlow flow) {
		
		i.documentation('''Class of the state machine '«i.name»'.''')
		
		i._csharpClass
		
		i.traceOrigin(flow.statechart)
		
		EcoreUtil2.getAllContainers(i).filter(Package).forEach[ it._namespace ]
		
		flow.statechart.createTypeDescription
		
		val statechartTypeDescription = flow.statechart.statechartType
		
		i.superTypes += createTypeSpecifier => [
				
			val execType = statechartTypeDescription.superTypes.head.type.asCsharpDeclaration
			
			type = flow.appliesSubMachine ? getSubmachineInterface.asCsharpDeclaration : execType
			
		]
		
		flow.definePropertyChangedEvent
		
		if(flow.timed){
			createTimedInterface
						
			i.superTypes += createTypeSpecifier => [
				type = timedType
			]
		}
		
		if (flow.requiresEventQueue) {
			flow.defineEventQueueImplementation
		}
		
		//Has to be after "defineEventQueueImplementation"
		flow.transformExecDefinedConcepts(i)
		
		if(entry.isThreadSafeAccess){
			i.addAsyncAwait(flow.requiresEventQueue)
			if(flow.triggerWithoutEvents !== null){
				flow.triggerWithoutEvents.implementation =  flow.triggerWithoutEvents.guardWithSemaphore(flow.triggerWithoutEvents.implementation, false)
				flow.triggerWithoutEvents.changeReturnTypeToAsyncTask
			}					
		}
		
		flow.namedInterfaceClasses
				
		flow.operationCallback(i)
		
		flow.defineStateEnum(i)
		
		flow.defineEvents
		
		flow.defineMembers
		
		flow.defineProperties		
		 
		flow.defineStateMetaInformation
		
		flow.defineFunctions
		
		
		
		flow.transformEventBuffer
		
		flow.copyNamedIfaceFunctionDeclarations
		
		i.defineConstructor

		i.generateDefinitionWith[ '''
			«i.classDeclaration» {
				«FOR f : i.features»
					
					«f.declarationCode»
				«ENDFOR»
				«FOR f : i.features»
					
					«f.definitionCode»
				«ENDFOR»
				«flow.functionImplementations»
				«i.features.filter(Method).toMethodDefinitions»
			}

		''' ]
	}
	
	
}
