/**
 * Copyright (c) 2022-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.concepts.AsyncAwait
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.core.codemodel.StatemachineProperties
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.concepts.LoggerTypeLibrary
import com.yakindu.sct.model.sexec.concepts.SubMachine

/**
 * @author laszlo kovacs - Initial contribution.
 */
 @Singleton
class CsharpStatemachineProperties extends StatemachineProperties {
	
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension CsharpEventQueueImplementation
	@Inject protected extension EventQueueExtension
	@Inject protected extension AsyncAwait
	@Inject protected GeneratorEntry entry
	@Inject protected extension CsharpGenmodelEntries
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension LoggerTypeLibrary
	@Inject protected extension SubMachine
	
	override definePropertie(Property p) {
		if(p.type !== getLoggerType){
			if (p.type instanceof ComplexType)
				_part(p.name, p.type) => [
					p.annotations.forEach[ annot |
						annotations += annot.copy
					]
					generalProperties(p)
				]
			else
				_variable(p.name, p.type) => [
					generalProperties(p)
					generateDefinitionWith[getterSetter(true, true,"")]
				]
		}		
	}
	
	override protected queueTimeEvent(ExecutionFlow flow, AssignmentExpression assignExpr){
		flow.incomingEventQueue._ref._dot(flow.enqueue)._with(
			createLambdaExpression => [
				expression = assignExpr
			]
		)
	}
	
	override addTimeEventsMember(ExecutionFlow flow, ComplexType clazz){
		val timeEventsVariable = 
		timeEventsVariable(flow, flow.timeEvents.size) => [
			traceOrigin(flow.timeEvents)
			_internallyDefinedType
			const = false
			_readonly
		]
		clazz.features += 
			if(timeEventsVariable.eContainer !== null)
				timeEventsVariable.copy
			else timeEventsVariable
	}
	
	//TODO: This should be generalized and moved to 'StatemachineProperties' once SerializedAccess is available for all target language
	override defineRaiseTimeEvent(ExecutionFlow flow) {
		val method = _op(raiseTimeEvent, _void) => [ op |
			val param = createParameter => [
				name = "eventID"
				typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = _integer
				]
			]
			op.parameters += param
			op._public
			op.static = false
			
			val eventHandlingBlock = _block() => [
				if(flow.requiresIncomingEventQueue){
					expressions += flow.queueTimeEvent(flow.setTimeEventTrue(param))
				} else
					expressions += flow.setTimeEventTrue(param)
				if(!flow.appliesSubMachine && flow.isEventDriven && flow.stateMachineClass.runCycle !== null)
					expressions += flow.stateMachineClass.runCycle._call
				if(flow.appliesSubMachine)
					expressions += flow.submachineContextMember._ref._call(flow.submachineContextMember.type.eventRaised)
			]
			
			if(entry.isThreadSafeAccess){
				op.implementation = timeEventsVariable(flow, flow.timeEvents.size).guardWithSemaphore(eventHandlingBlock, true)		
			} else		
				op.implementation = eventHandlingBlock

			op.generateDefinitionWith[ op.methodDefinitionCode ]
		]
		return method
	}
	
}
