/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.TimerService
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineFunctions
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.templates.SexecGenerator
import com.yakindu.sct.model.sexec.Call
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.CheckRef
import com.yakindu.sct.model.sexec.DoWhile
import com.yakindu.sct.model.sexec.EnterState
import com.yakindu.sct.model.sexec.ExitState
import com.yakindu.sct.model.sexec.HistoryEntry
import com.yakindu.sct.model.sexec.If
import com.yakindu.sct.model.sexec.SaveHistory
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.StateSwitch
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sexec.concepts.MicroStep
import com.yakindu.sct.model.sexec.concepts.SuperStep
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.util.SgraphExtensions
import java.util.List

class CsharpFlowCode extends SexecGenerator{
	
	@Inject protected extension StateEnum
	@Inject protected extension INamingService
	@Inject protected extension TimerService
	@Inject protected extension SuperStep
	@Inject protected extension MicroStep
	@Inject protected extension Literals
	@Inject protected extension CsharpStatemachineFunctions
	@Inject protected extension SgraphExtensions
			
	var List<TimeEvent> timeEvents;
		
		
	def dispatch CharSequence code(StateSwitch it) '''
		«IF historyRegion !== null»
			switch (historyVector[«historyRegion.historyVector.offset»]) {
		«ELSE»
			switch («stateConfVector»[«stateConfigurationIdx»]) {
		«ENDIF»
		«FOR stateCase : cases»
			case «stateCase.state.enumerator.asLiteral»:
				«IF stateCase.step !== null»«stateCase.step.code»«ENDIF»
				break;
		«ENDFOR»
		default:
			break;
		}
	'''
	
	def dispatch CharSequence code(ScheduleTimeEvent it) '''
		«stepComment»
		«timerService».«setTimer»(this, «getTimeEvents.indexOf(timeEvent)», «timeValue.code», «IF timeEvent.periodic»true«ELSE»false«ENDIF»);
		«traceCode»
	'''
	
	def dispatch CharSequence code(UnscheduleTimeEvent it) '''
		«stepComment»
		«timerService».«unsetTimer»(this, «getTimeEvents.indexOf(timeEvent)»);
		«traceCode»
	'''
	
	def dispatch CharSequence code(Call it) '''«step.shortName.toFirstUpper»();'''
	
	
	def dispatch CharSequence code(Check it) {
		if (condition !== null) 
			'''«condition.code»«IF condition instanceof ArgumentExpression» == true«ENDIF»'''
		else 
			'''true'''
	}

	def dispatch CharSequence code(CheckRef it) '''«IF check !== null»«comment»«check.shortName»()«ELSE»true«ENDIF»'''
	
	
	def dispatch CharSequence code(If it) '''
		«stepComment»
		if («check.code.toString.trim») {
			«thenStep.code»
		}«IF elseStep !== null» else {
					«elseStep.code»
			}
		«ENDIF»
	'''
	
	def dispatch CharSequence code(DoWhile it) '''
		«stepComment»
		do { 
			«body.code»
		} while («check.code»);
	'''

	def dispatch CharSequence code(EnterState it) {
	val firstPos = state.statevectorFirstPosition
	val lastPos = state.statevectorLastPosition
	'''
		«stepComment»
		«FOR i: firstPos .. lastPos»
			«stateConfVector»[«i»] = «state.enumerator.asLiteral»;
		«ENDFOR»
		«IF flow.needsStateVectorPosition»
			«MicroStep.STATE_VECTOR_POSITION» = «firstPos»;
		«ENDIF»
		«flow._stateChanged.code»
	'''
	}
	
	def dispatch CharSequence code(ExitState it) {
	val parentState = it.state.sourceElement.parentState
	val stateName = if ( parentState !== null ) parentState.enumerator.asLiteral else flow.noStateEnumerator.asLiteral
	val firstPos = state.statevectorFirstPosition
	val lastPos = state.statevectorLastPosition
	'''
		«stepComment»
		«FOR i: firstPos .. lastPos»
			«stateConfVector»[«i»] = «stateName»;
		«ENDFOR»
		«IF flow.needsStateVectorPosition»
			«MicroStep.STATE_VECTOR_POSITION» = «lastPos»;
		«ENDIF»
	'''
	}
	
	def dispatch CharSequence code(HistoryEntry it) '''
		«stepComment»
		if (historyVector[«region.historyVector.offset»] != «flow.noStateEnumerator.asLiteral») {
			«historyStep.code»
		} «IF initialStep !== null»else {
					«initialStep.code»
		}«ENDIF»
	'''
	
	def dispatch CharSequence code(SaveHistory it) '''
		«stepComment»
		historyVector[«region.historyVector.offset»] = «stateConfVector»[«region.stateVector.offset»];
	'''
	
	def private getTimeEvents(Step it) {
		if (timeEvents === null) {
			timeEvents = flow.timeEvents
		}
		return timeEvents
	}

}
