/**
 * Copyright (c) 2023-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.csharp.codepattern.ExpressionCode
import com.itemis.create.base.generator.csharp.concepts.AsyncAwait
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineNaming
import com.itemis.create.statechart.generator.csharp.transformation.OutPropertyEventHandler
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.ConditionalExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FloatLiteral
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.IntLiteral
import com.yakindu.base.expressions.expressions.LogicalAndExpression
import com.yakindu.base.expressions.expressions.LogicalOrExpression
import com.yakindu.base.expressions.expressions.MetaCall
import com.yakindu.base.expressions.expressions.ParenthesizedExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.types.ArrayTypeSpecifier
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.annotations.TraceAnnotations
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.codemodel.StatemachineFunctions
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import org.eclipse.emf.ecore.EObject

/**
 * @author laszlo kovacs - Initial contribution.
 */
class CsharpStatemachineExpressionCode extends ExpressionCode {
	
	static val String CONSTRUCTOR = "new"
	
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension StatemachineFunctions
	@Inject protected extension SExecExtensions
	@Inject protected extension ITypeSystemInferrer
	@Inject protected extension EventBuffer
	@Inject protected extension StateEnum
	@Inject protected extension	TraceAnnotations
 	@Inject extension protected OriginTracing	
	@Inject protected extension CsharpTraceCode
	@Inject protected extension AsyncAwait
	@Inject protected extension OutPropertyEventHandler
	
	override dispatch CharSequence code(PrimitiveValueExpression it){
		if(eContainer instanceof TypedDeclaration){
			val typedContainer = eContainer as TypedDeclaration
			if(typedContainer.typeSpecifier instanceof ArrayTypeSpecifier){
				'''new «typedContainer.typeSpecifier.asLiteral»[«super._code(it)»]'''
			}
			else super._code(it)
		}
		else super._code(it)
	}

	//TODO: Re-Evaluate whether this is needed or not
	override dispatch CharSequence code(ConditionalExpression it) {
		if(condition.featureOrReference.userDeclared) '''(«condition.code» ?? true) ? «trueCase.code» : «falseCase.code»'''
		else super._code(it)
	}
	
	override dispatch CharSequence code(ParenthesizedExpression it) '''(«expression.code»«IF eContainer instanceof LogicalAndExpression || eContainer instanceof LogicalOrExpression» == true«ENDIF»)'''
	
	override dispatch CharSequence code(InitializationExpression it) {
		
		var originType = it.infer.type

		if(originType === _event_handler)
			'''«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»'''
		// TODO: we always have to use a normalized / ordered argument list. we should not care about this aspect here in the 2text transformation.
		//Either names or order is correct
		else if (originType !== null && originType instanceof ComplexType) {
			if(arguments.forall[a | a.parameter !== null && a.parameter.name !== null])
			'''«CONSTRUCTOR» «originType.asLiteral»(«FOR p : originType.features.filter(Property) SEPARATOR ','»«arguments.filter(pr | pr.parameter.name.equals(p.name)).head.value.code»«ENDFOR»)'''
			else
			'''«CONSTRUCTOR» «originType.asLiteral»«originType.specifyGenericType»(«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»)'''

		} 
		//For now lets be forgiving regarding inferred type, and assume that order is correct and type is correctly infered for the container
		else if(eContainer instanceof Property){
			originType = (eContainer as Property).typeSpecifier.getType
			'''«CONSTRUCTOR» «originType.asLiteral»(«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»)'''
		}
		
		else
			super._code(it)
	}
	
	def dispatch CharSequence code(ActiveStateReferenceExpression it) 
		'''«isStateActiveName»(«value.enumerator.asLiteral»)'''
		
	override dispatch String code(ElementReferenceExpression it) {
		val ref = it.reference
		//TODO: Remove once Trace is conceptualized
		if(ref.trace){
			if(ref.hasValue)
				return (ref.origin as EObject).traceCode("value").toString
			else
				return (ref.origin as EObject).traceCode("null!").toString
		}
		
		return super._code(it).toString
	}

	def dispatch String code(MetaCall it) {
		feature.metaCode(owner)
	}

	def dispatch String metaCode(EObject it, Expression exp) '''/* cant generate meta code for «it» of «exp» */'''
		
	def dispatch String metaCode(Property it, ArgumentExpression exp) {
		// Required custom code struct for C# await concept
		if(it === await)
			'''«name» «exp.code»'''
		// Legacy requirement from SExec react (Should go in the end)
		else
			'''«exp.code»«name.toFirstUpper»'''
	}

	override dispatch CharSequence code(FloatLiteral it) '''«value.toString»F'''

	override dispatch CharSequence code(IntLiteral it) '''«value.toString»L'''
	
}