/**
 * Copyright (c) 2025-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.transformation

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpEventQueueImplementation
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.BlockExpression
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.concepts.SubMachine
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.itemis.create.statechart.generator.csharp.codemodel.CsharpEventQueueImplementation.*

/**
 * 
 * This transformation is responsible to transform the named concept sequences
 * defined in the ExecFlow. Currently it only takes care of the 'EventProcessing.NEXT_EVENT'
 * In the future it should be extended when / if the ownership of the operations 
 * defined in the ExecFlow get's transfered to the statemachine class code model.
 * 
 * @author laszlo kovacs - Initial contribution
 *
 */
@Singleton
class ConceptSequenceTransformation {
	
	@Inject protected extension ExpressionBuilder
	@Inject protected extension TypeBuilder
	@Inject protected extension SExecExtensions
	@Inject protected extension ExpressionExtensions
	@Inject protected extension EventQueueExtension
	@Inject protected extension CsharpEventQueueImplementation
	
	@Inject protected extension SubMachine
	@Inject protected GeneratorEntry entry
	@Inject extension protected CsharpGenmodelEntries
	@Inject protected extension OriginTracing
	
	def transformConcepts(Operation it, ComplexType target){
		eAllContents.filter(ArgumentExpression).filter[(featureOrReference as NamedElement).name === EventProcessing.NEXT_EVENT
			].forEach[ nextEvent |
				EcoreUtil.replace(nextEvent, target.features.filter(Operation).filter[name === GET_NEXT_EVENT_METHOD_NAME].head._call)	
			]
		
		val traceExprToRemove = newHashSet
		eAllContents.filter(ArgumentExpression).filter[(featureOrReference as NamedElement).name === SubMachine.TRACE_SUBCYCLE_START
			|| (featureOrReference as NamedElement).name === SubMachine.TRACE_SUBCYCLE_END
			].forEach[ traceSubcycleStart |
				if(entry.tracingGeneric){
					val traceRunCycle = (traceSubcycleStart.featureOrReference as Sequence).steps.head
					traceRunCycle.traceOrigin(target.origin)
					val tracePart = _tracePart => [ traceOrigin(traceRunCycle)]
					EcoreUtil.replace(traceSubcycleStart, tracePart._ref)
				} else
					traceExprToRemove += traceSubcycleStart
			]
		if(!traceExprToRemove.nullOrEmpty && !(it instanceof Method))
			(it.implementation as BlockExpression).expressions.removeAll(traceExprToRemove)
		return it
	}
	
	def protected create it : _part("trace") _tracePart(){
		_trace
	}
}