/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.types

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineNaming
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sgraph.util.StatechartUtil

import static com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder.CSHARP_EVENT_ARGS
import static com.itemis.create.base.generator.csharp.concepts.OutEvent.HANDLER
import static com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineOperationCallbacks.OPERATION_CALLBACK_INTERFACE
import static com.yakindu.base.types.typesystem.ITypeSystem.INTEGER
import static com.yakindu.base.types.typesystem.ITypeSystem.STRING
import static com.yakindu.base.types.typesystem.ITypeSystem.VOID

/**
 * @author laszlo kovacs- Initial contribution.
 */
class CsharpTypeSystemAccess implements ICodegenTypeSystemAccess {
	
	@Inject	protected extension ITypeSystem
	@Inject protected extension StatechartUtil
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension Literals
	
	static String DOUBLE = "double"
	static String BOOL = "bool"
	static String LONG = "long"

	override getTargetLanguageName(Type type) {
		type.csharpName
	}
	
	override getTargetLanguageName(TypeSpecifier typeSpecifier) {
		getTargetLanguageName(typeSpecifier?.type)
	}
	
	def protected dispatch csharpName(Type type) {
		switch type {
			case type === null || type.isSame(getType(VOID)) : VOID
			case type.isReal: DOUBLE
			case type.isInteger || isSuperType(type, getType(INTEGER)): LONG
			case type.isBoolean: BOOL
			case type.isString: STRING
			// multi SM
			EnumerationType case type.isOriginStatechart: type.name +"_"+ type.getOriginStatechart.name
			ComplexType case type.isOriginStatechart: type.name +"_"+  type.getOriginStatechart.name
			EnumerationType : type.namespacePath + type.name
			Enumerator : type.name
			//Special cases for C# (Do It like this or like in the events?)
			case type.name.contains(HANDLER) : type.name
			case type.name.contains(CSHARP_EVENT_ARGS) : type.name
			case OPERATION_CALLBACK_INTERFACE.equals(type.name) : type.name
			ComplexType : type.namespacePath + type.name
			
			default: "//" + type
		}
	}
	
	def protected dispatch csharpName(ComplexType type) {
		type.name
	}
	
	def protected dispatch csharpName(Void type) {
		VOID
	}
	
	
}
