/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.artifacts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.artifacts.IContent
import com.itemis.create.base.generator.core.artifacts.IGenArtifact
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.yakindu.sct.model.sgen.GeneratorEntry

@Singleton
class CsharpITimerService implements IContent, IGenArtifact {
	
	@Inject protected GeneratorEntry entry
	@Inject protected extension CsharpGenmodelEntries
			
	override content()'''
	namespace «entry?.getTimerLibraryPackage»{
	    public interface ITimerService
	    {
	        /// <summary>
	        /// Starts the timing for a given time event id.
	        /// </summary>
	        /// <param name="callback">An ITimed object that is called when the timer expires.</param>
	        /// <param name="eventID">The id of the state machine's time event.</param>
	        /// <param name="time">Time in milliseconds after which the time event should be triggered.</param>
	        /// <param name="isPeriodic">Set to true to trigger the time event periodically.</param>
	        void SetTimer(ITimed callback, int eventID, long time, bool isPeriodic);
	        
	        /// <summary>
	        /// Unsets a time event.
	        /// </summary>
	        /// <param name="callback">An ITimed object that is called when the timer expires.</param>
	        /// <param name="eventID">The id of the state machine's time event.</param>
	        void UnsetTimer(ITimed callback, int eventID);
	    }
	}
	'''
	
}