/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.csharp.codepattern.MethodCode
import com.itemis.create.base.generator.csharp.concepts.AsyncAwait
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.itemis.create.base.generator.csharp.transformation.Slang2CsharpTransformation
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Package
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.concepts.SubMachine.SubmachineTypeLibrary
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.types.lib.StatechartLibrary

import static com.yakindu.sct.types.lib.StatechartLibrary.TRIGGER_WITHOUT_EVENT_NAME

/**
 * Creates and provides the C# code model of the base statemachine interfaces.
 * 
 * @author Axel Terfloth (terfloth@itemis.de)
 */
@Singleton
class CsharpStatemachineLibrary {

	public static final String FILE_NAME = "Statemachines"

	@Inject protected extension OriginTracing
	@Inject protected extension CsharpCompilationUnit
	@Inject protected extension Slang2CsharpTransformation transformation
	@Inject protected extension CsharpClass
	@Inject protected extension CsharpNamespace
	@Inject protected extension CsharpGenmodelEntries
	@Inject protected extension GeneratorAssignment
	@Inject protected GeneratorEntry entry
	@Inject protected extension MethodCode
	@Inject protected StatechartLibrary lib
	@Inject protected extension AsyncAwait
	@Inject protected SubmachineTypeLibrary subMachinelib

	def create slCu : transformStateMachineLibrary statemachineLibrary() {
		slCu.name = FILE_NAME
		slCu._namespace
		slCu._compilationUnit(entry?.getLibraryPackage)

		slCu.member += hierarchyTransformation(statemachineInterface.interfaceTransformation)
		slCu.member += hierarchyTransformation(eventDrivenStatemachineInterface.interfaceTransformation)
		slCu.member += hierarchyTransformation(cycleBasedStatemachineInterface.interfaceTransformation)
		slCu.member += hierarchyTransformation(csharpSubStatemachineInterface.interfaceTransformation)
		slCu.member += hierarchyTransformation(csharpSubmachineContextInterface.interfaceTransformation)

	}

	def interfaceTransformation(ComplexType ct) {
		ct.name = "I" + ct.name
		ct._csharpInterface
		ct.features.filter(Operation).forEach [
			generateDefinitionWith[methodDeclarationCode]
		]
		ct
	}

	def hierarchyTransformation(ComplexType ct) {
		_compilationUnit => [ cu |
			cu.name = ct.name
			cu.member += _namespace => [ ns |
				ns.name = entry?.getLibraryPackage
				ns.member += ct
			]
		]
	}

	def protected transformStateMachineLibrary() {
		val typesPack = lib.typesPackage.transform as Package
		typesPack.member += (subMachinelib.getLibraryPackage.transform as Package).member
        //typesPack.member += subMachinelib.getLibraryPackage.transform
		typesPack
	}

	def statemachineInterface() {
		lib.statemachine.asCsharpDeclaration as ComplexType
	}

	def eventDrivenStatemachineInterface() {
		val evDrivenSupType = lib.eventDriven.asCsharpDeclaration as ComplexType
		if(entry.isThreadSafeAccess){
			evDrivenSupType.features.filter(Operation).filter[name.toFirstLower == TRIGGER_WITHOUT_EVENT_NAME].head.changeReturnTypeToTask
		}
		evDrivenSupType
	}

	def cycleBasedStatemachineInterface() {
		lib.cycleBased.asCsharpDeclaration as ComplexType
	}
	
	def csharpSubStatemachineInterface() {
		subMachinelib.submachineInterface.asCsharpDeclaration as ComplexType
	}
	
	def csharpSubmachineContextInterface() {
		subMachinelib.getSubmachineContextInterface.asCsharpDeclaration as ComplexType
	}

	def create r : it.findCsharpDeclaration asCsharpDeclaration(Declaration it) {}

	def protected findCsharpDeclaration(Declaration it) {
		statemachineLibrary.eAllContents.filter(ComplexType).findFirst[e|e.origin === it]
	}
}
