/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.Expression
import com.yakindu.base.types.TypeBuilder
import java.util.List
import org.eclipse.emf.ecore.EObject
import com.google.inject.Singleton

/**
 * @author laszlo kovacs- Initial contribution.
 */
@Singleton
class CsharpTypeBuilder {
	
	@Inject protected extension TypeBuilder
	
	public static String CSHARP_DELEGATE_ANNOTATION = "delegate"
	public static String CSHARP_HANDLER_ANNOTATION = "handler"
	public static String CSHARP_EVENT_ANNOTATION = "event"
	public static String CSHARP_NULLABLE = "__nullable__"
	public static String CSHARP_REQUIRED = "__required__"
	public static String CSHARP_GENERIC_TYPE = "__generic_type__"
	public static String CSHARP_USER_DECLARED = "__user_declared__"
	public static String CSHARP_READONLY = "readonly"
	public static String ABSTRACT = "_abstract_"
	public static String CSHARP_EVENT_ARGS = "EventArgs"
	public static List<String> ANNOTATIONS = #[CSHARP_DELEGATE_ANNOTATION,CSHARP_EVENT_ARGS,CSHARP_READONLY,CSHARP_EVENT_ANNOTATION]
	
	
	def <T extends AnnotatableElement> T _generic_type(T e) {
		e._annotate(CSHARP_GENERIC_TYPE)
	}
	
	def isGeneric_type(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_GENERIC_TYPE) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _delegate(T e) {
		e._annotate(CSHARP_DELEGATE_ANNOTATION)
	}
	
	def isDelegate(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_DELEGATE_ANNOTATION) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _nullable(T e) {
		e._annotate(CSHARP_NULLABLE)
	}
	
	def isNullable(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_NULLABLE) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _handler(T e) {
		e._annotate(CSHARP_HANDLER_ANNOTATION)
	}
	
	def isHandler(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_HANDLER_ANNOTATION) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _required(T e) {
		e._annotate(CSHARP_REQUIRED)
	}
	
	def isRequired(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_REQUIRED) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _user_declared(T e) {
		e._annotate(CSHARP_USER_DECLARED)
	}
	
	def dispatch isUserDeclared(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_USER_DECLARED) !== null) return true
		else false
	}
	
	def dispatch isUserDeclared(EObject it){
		return false
	}
	
	def dispatch isUserDeclared(Void it){
		return false
	}
	
	def <T extends AnnotatableElement> T _readonly(T e) {
		e._annotate(CSHARP_READONLY)
	}
	
	def isReadonly(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_READONLY) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _event(T e) {
		e._annotate(CSHARP_EVENT_ANNOTATION)
	}
	
	def isEvent(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_EVENT_ANNOTATION) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _abstract(T e) {
		e._annotate(CsharpTypeBuilder.ABSTRACT)
	}
	
	def isAbstract(AnnotatableElement it){
		if(getAnnotationOfType(CsharpTypeBuilder.ABSTRACT) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _eventArgs(T e, Expression... args) {
		e._annotate(CSHARP_EVENT_ARGS, args)
	}
	
	def iseventArgs(AnnotatableElement it){
		if(getAnnotationOfType(CSHARP_EVENT_ARGS) !== null) return true
		else false
	}
	
	def getDeclType(AnnotatableElement it) {
		for (a : ANNOTATIONS) {
			if(getAnnotationOfType(a) !== null) return a
		}
	}
	
	def create it : _complexType("Action") _action(){
		
	}
	
	def create it : _complexType("object") _object(){
		_required
	}
	
	def create it : _complexType("Action") _action_with_object(){
		superTypes += _object._typeSpecifier
	}
	
}
