/**
 * Copyright (c) 2023-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.BinaryExpression
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.LambdaExpression
import com.yakindu.base.expressions.expressions.LogicalAndExpression
import com.yakindu.base.expressions.expressions.LogicalOrExpression
import com.yakindu.base.expressions.expressions.ShiftExpression
import com.yakindu.base.expressions.expressions.ShiftOperator
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Argument
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Package
import com.yakindu.base.types.Part
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import org.eclipse.emf.ecore.EObject
import com.itemis.create.base.generator.core.codepattern.TypeSystemAccessExpressionCode

/**
 * @author laszlo kovacs - Initial contribution.
 */
class ExpressionCode extends TypeSystemAccessExpressionCode {
	
	@Inject protected extension CsharpLiterals
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension Statechart2TypeTransformation
	@Inject protected extension ExpressionExtensions
	
	
	def protected dispatch symbol(Enumerator it) {
		//That means the type for the Enumerator is part of the resource thus to refer it the FeatureCall chain is calculated
		if(it.eContainer.eContainer instanceof Package)
			it.name
		else
			asLiteral
	}
	
	def protected dispatch symbol(Void it) {
	}
	
	def protected dispatch symbol(Operation it) {
		if(!typeParameters.nullOrEmpty)
			'''«name»<«FOR tp : typeParameters SEPARATOR ','»«tp.bound.asLiteral»«ENDFOR»>'''
		else
			name
	}
	
	//TODO: Re-Evaluate whether this is needed or not
	def dispatch CharSequence code(LogicalAndExpression it) {
		if(leftOperand.featureOrReference.isUserDeclared || rightOperand.featureOrReference.isUserDeclared)
			logicalAndOrCode
		else
			super._code(it)
	}
	
	//TODO: Re-Evaluate whether this is needed or not
	def dispatch CharSequence code(LogicalOrExpression it) {
		if(leftOperand.featureOrReference.isUserDeclared || rightOperand.featureOrReference.isUserDeclared)
			logicalAndOrCode
		else
			super._code(it)
	}
	
	//TODO: Re-Evaluate whether this is needed or not
	def logicalAndOrCode(BinaryExpression it) '''(«leftOperand.code.toString.trim»«IF leftOperand.featureOrReference.isUserDeclared» ?? true«ENDIF») «operator.literal.toString.trim» («rightOperand.code»«IF rightOperand.featureOrReference.isUserDeclared» ?? true«ENDIF»)'''
	
	override dispatch String code(AssignmentExpression it) {
		return '''«varRef.code» «operator» «IF operator == AssignmentOperator.LEFT_SHIFT_ASSIGN || operator == AssignmentOperator.RIGHT_SHIFT_ASSIGN»(int)«ENDIF»«expression.code»'''
	}
	
	def dispatch String code(ShiftExpression it){
		'''(«leftOperand.code.toString.trim» «operator.literal.toString.trim» «IF operator == ShiftOperator.LEFT || operator == ShiftOperator.RIGHT»(int)«ENDIF»«rightOperand.code»)'''
	}
	
	override dispatch CharSequence code(InitializationExpression it) {
		val originType = it.eContainer.determineOriginType
		if(originType !== null){
			'''«originType.instantiationCode»(«FOR a : arguments SEPARATOR ','»«IF a.value !== null»«a.value.code»«ENDIF»«ENDFOR»)'''
		}
		//If no type was determined try to go deeper 
		else '''«FOR a : arguments SEPARATOR ','»«IF a.value !== null»«a.value.code»«ENDIF»«ENDFOR»'''
	}
	
	def dispatch protected determineOriginType(AssignmentExpression it){
		(varRef.featureOrReference as TypedDeclaration).type
	}
	
	def dispatch protected determineOriginType(Argument it){
		if(parameter instanceof Part){
			parameter.type
		} else
			parameter
	}
	
	def dispatch protected determineOriginType(EObject it){}
	
	def dispatch instantiationCode (Property it) {
		if(initialValue !== null)
			initialValue.code
		else
			'''new «type.asLiteral»«type.specifyGenericType»()'''
	}
		
		
	def dispatch instantiationCode (Type it) 
		'''new «asLiteral»«specifyGenericType»'''
	
	def CharSequence specifyGenericType(Type it){
		if(!superTypes.nullOrEmpty && superTypes.head.type.required){
			'''<«superTypes.head.type.asLiteral»>'''
		} else ''''''
	}
	
	def dispatch CharSequence code(LambdaExpression it) {
		'''(«parameters.paramCode») => «expression.code»'''
	}
	
}