/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.itemis.create.base.generator.csharp.concepts.AsyncAwait
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypeSpecifier
import com.itemis.create.base.generator.core.codepattern.TypeSystemAccessExpressionCode
import com.yakindu.base.types.annotations.TypeAnnotations

/**
 * The standard implementation pattern for method generation. 
 * 
 * @author laszlo kovacs - Initial contribution.
 */
class MethodCode implements IMethodCode {
	
	@Inject protected extension CsharpVisibility
	@Inject protected extension TypeSystemAccessExpressionCode
	@Inject protected extension CodeComment
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension TypeAnnotations
	@Inject protected extension AttributeCode
	@Inject protected extension Literals
	@Inject protected extension AsyncAwait
	@Inject protected extension TypeBuilder
	
	override methodDefinitionCode(Operation it) '''
		«codeComment»
		«attributeCode»
		«it.csharpVisibility» «IF abstract»abstract«ENDIF» «IF !hasNoReturnTypeAnnotation»«typeSpecifier.asLiteral» «ENDIF»«IF !typeSpecifier.typeArguments.nullOrEmpty»<«FOR ta : typeSpecifier.typeArguments SEPARATOR ","»«ta.asLiteral»«ENDFOR»>«ENDIF» «name»(«FOR p:parameters SEPARATOR ", "»«IF !iseventArgs»«p.typeSpecifier.asLiteral»«ENDIF» «p.name»«ENDFOR») «IF it.implementation === null»;«ELSE»«it.implementation.code» «ENDIF»
	'''
	
	override methodDeclarationCode(Operation it) '''
		«codeComment»
		«it.csharpVisibility» «declType» «typeSpecifier.determineReturnType» «name»(«FOR p:parameters SEPARATOR ", "»«IF !iseventArgs»«p.typeSpecifier.asLiteral»«ENDIF» «p.name»«ENDFOR»);
	'''
	
	def determineReturnType(TypeSpecifier it){
		if(type === asyncTaskType){
			if(typeArguments.nullOrEmpty)
				return taskType.asLiteral
			else
				return typeArguments.head.asLiteral
		} else
			return asLiteral
		
	}
	
	def notImplementedException() '''
	{ throw new NotImplementedException(); }'''
	
	
}
