/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.features

import com.yakindu.sct.generator.core.library.impl.CoreFeatureTypeLibraryProvider

import static com.yakindu.base.types.typesystem.ITypeSystem.*

import static com.itemis.create.base.generator.csharp.features.ICsharpFeatureConstants.*

/**
 * @author laszlo kovacs - Initial contribution.
 */
class CsharpFeatureTypeLibraryProvider extends CoreFeatureTypeLibraryProvider {
	
	override outEventAPI() {
		createFeatureType => [
			name = "OutEventAPI"
			optional = true
			parameters += createFeatureParameter => [
				name = "getters"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}
	
	def naming() {
		createFeatureType => [
			name = NAMING_FEATURE
			optional = true
			parameters += createFeatureParameter => [
				name = LIBRARY_NAMESPACE
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = BASE_NAMESPACE
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = TYPE_NAME
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = GENERATED_FILE_EXTENSION
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def generalFeatures() {
		createFeatureType => [
			name = GENERAL_FEATURES
			optional = true
			parameters += createFeatureParameter => [
				name = TIMER_SERVICE
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = THREAD_SAFE_ACCESS
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}
	
	def csharpFeatures() {
		createFeatureType => [
			name = CSHARP_FEATURES
			optional = true
			parameters += createFeatureParameter => [
				name = "compilerPragma"
				parameterType = getType(STRING)
			]
		]
	}
	
	def tracing() {
		createFeatureType => [
			name = "Tracing"
			optional = true
			parameters += createFeatureParameter => [
				name = "generic"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	override provide() {
		create([super.provide]) => [
			name = "C# Generator"
			types += naming()
			types += generalFeatures()
			types += csharpFeatures()
			types += tracing()
		]
	}
}
