/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.transformation

import com.google.inject.Inject
import com.itemis.create.base.generator.core.Transformation
import com.itemis.create.base.generator.csharp.codemodel.CsharpNaming
import com.itemis.create.base.generator.csharp.concepts.EventRaiser
import com.itemis.create.base.generator.csharp.concepts.OutEvent
import com.yakindu.base.types.Declaration

/**
 * Default transformation of Slang declarations to C# code model
 * 
 * @author Axel Terfloth
 */
class Slang2CsharpTransformation extends Transformation<Declaration, Declaration> {
	
	@Inject protected extension CsharpNaming
	@Inject protected extension EventRaiser
	@Inject protected extension OutEvent
	@Inject protected extension TimerNamespaceTransformation
	
	
	override protected Declaration toTarget(Declaration decl) {
		decl.createCopy => [
			defineEventRaiser
			defineEventDefinition
			applyCsharpNamingConventions
			it.transformedRootFrom(decl)
		]
		
	}
	
	override protected modifyTarget(Declaration decl){
		transformTimerFeaturesNamespace
	}
	
}