/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.transformation

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.TimedInterface
import com.itemis.create.base.generator.core.concepts.TimerService
import com.itemis.create.base.generator.core.concepts.VirtualTimer
import com.itemis.create.base.generator.csharp.codemodel.CsharpNamespace
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.google.inject.Singleton

/**
 * @author laszlo kovacs - Initial contribution.
 */
@Singleton
class TimerNamespaceTransformation {
	
	@Inject protected extension TimedInterface
	@Inject protected extension TimerService
	@Inject protected extension VirtualTimer
	@Inject protected extension CsharpNamespace
	
	@Inject protected GeneratorEntry entry
	@Inject protected extension CsharpGenmodelEntries
	
	def void transformTimerFeaturesNamespace(){
			#[timedType,virtualTimerInterfaceType,virtualTimerType].filterNull.forEach[ timerType |
				_namespace => [ ns |
					ns.name = entry?.getTimerLibraryPackage
					ns.member += timerType
				]
			]
	}
}