/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	andreas muelder - itemis AG
 *
 */
package com.yakindu.sct.domain.java.scoping

import com.yakindu.sct.domain.java.typesystem.JavaTypeSystem
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.sct.model.stext.scoping.STextScopeProvider
import com.yakindu.base.types.EnumerationType

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class JavaScopeProvider extends STextScopeProvider {

	override IScope scope_FeatureCall_feature(FeatureCall context, EReference reference) {
		val owner = context.owner.owner
		if (owner instanceof ComplexType) {
			var elements = owner.allFeatures.filter[static].filter[!isSuperTypeDefaultConstructor(owner)].toList
			if (owner instanceof EnumerationType) {
				elements += owner.enumerator
			}
			return Scopes.scopeFor(elements)
		}
		return super.scope_FeatureCall_feature(context, reference)
	}
		
	def boolean isSuperTypeDefaultConstructor(Declaration decl, ComplexType owner) {
		if (decl instanceof Operation) {
			return 
				decl.name === JavaTypeSystem.CONSTRUCTOR &&
				decl.parameters.empty && 
				decl.eContainer !== owner
		}
		return false
	}

	def dispatch getOwner(Expression it) {
		null
	}

	def dispatch getOwner(ElementReferenceExpression it) {
		return reference
	}

	def dispatch getOwner(FeatureCall it) {
		it.feature
	}
}
