/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.base.types.adapter

import org.eclipse.emf.ecore.EObject
import static com.yakindu.base.types.adapter.Adapters.*
/**
 * This extension provides access ImplicitAdapter marker adapter.
 * 
 * @author terfloth
 */
class ImplicitDefinitions {

	/** 
	 * Adds a structural trace to an element. 'origin' is the original element in the statechart. These kind of traces 
	 * can be used for navigation purpose.
	 */
	def <T extends EObject> T traceOrigin(T it, Object origin) {
		it.eAdapters.add(new OriginTraceAdapter(origin))
		return it
	}

	/** 
	 * @return true if element is marked as implicit.
	 */
	def boolean isImplicit(EObject it) {
		it.eAdapters.filter(ImplicitAdapter).size > 0
	}

	/**
	 * Sets an EObject to be implicit or not.
	 */
	def void setImplicit(EObject it, boolean implicit) {
		if (isImplicit) {
			if (!implicit) removeAdapter(it, ImplicitAdapter)
		}
		else {
			if (implicit) assignAdapter(it, new ImplicitAdapter)
		}
	}

}
