/**
* Copyright (c) 2024 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*/
package com.yakindu.base.types.annotations

import com.yakindu.base.types.AnnotatableElement
import org.eclipse.emf.ecore.EObject

/**
 * Defines annotations which classify model elements.
 * 
 * @author Axel Terfloth
 */
class ClassificationAnnotations {
	
	/**
	 * A synthetic element is implicitly created by a model transformation
	 * and represents some implementation detail which by default are irrelevant from
	 * the model perspective.
	 */
	public static String SYNTHETIC_ANNOTATION = "__synthetic__"
	
	/**
	 * A 'no instance' element has no intended runtime representation. 
	 * As such it won't be considere in slot construction or code variables 
	 */
	public static String NO_INSTANCE = "__no_instance__"

	def dispatch isSynthetic(AnnotatableElement it) {
		getAnnotationOfType(SYNTHETIC_ANNOTATION) !== null
	}
	
	def dispatch isSynthetic(EObject it) {
		false		
	}

	def dispatch isNoInstance(AnnotatableElement it) {
		getAnnotationOfType(NO_INSTANCE) !== null
	}
	
	def dispatch isNoInstance(EObject it) {
		false		
	}

}