/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.types.annotations

import com.yakindu.base.types.AnnotatableElement
import org.eclipse.emf.ecore.EObject

/**
 * Extension class which provides access to namespace related annotation
 * 
 * @author axel terfloth
 */
class NamespaceAnnotations {

	public static String NO_NAMESPACE_ANNOTATION = "__no_namespace__"

	/** If a type system element is explicitly no name space then this annotation is assigned. */
	def dispatch isNoNamespace(AnnotatableElement it){
		getAnnotationOfType(NO_NAMESPACE_ANNOTATION) !== null		
	}
	
	def dispatch isNoNamespace(EObject it){
		false		
	}
		
}