/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions

import com.google.inject.Binder
import com.yakindu.base.expressions.inferrer.ExpressionsTypeInferrer
import com.yakindu.base.expressions.linking.LinkingDiagnosticMessageProvider
import com.yakindu.base.expressions.parser.SyntaxErrorMessageProvider
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.typesystem.GenericTypeSystem
import com.yakindu.base.types.typesystem.ITypeSystem
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider
import com.yakindu.base.types.IDocumentor

class ExpressionsRuntimeModule extends AbstractExpressionsRuntimeModule {

	def configureITypeSystem(Binder binder) {
		binder.bind(ITypeSystem).toInstance(GenericTypeSystem.getInstance())
	}

	def Class<? extends ILinkingDiagnosticMessageProvider> bindILinkingDiagnosticMessageProvider() {
		LinkingDiagnosticMessageProvider
	}

	def Class<? extends ISyntaxErrorMessageProvider> bindISyntaxErrorMessageProvider() {
		SyntaxErrorMessageProvider
	}

	def Class<? extends ITypeSystemInferrer> bindITypeSystemInferrer() {
		return ExpressionsTypeInferrer
	}
	
	def Class<? extends IDocumentor> bindIDocumentor() {
		ExpressionsDocumentor
	}
	
}
