/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.base.expressions.formatting2

import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.BitwiseAndExpression
import com.yakindu.base.expressions.expressions.BitwiseOrExpression
import com.yakindu.base.expressions.expressions.BitwiseXorExpression
import com.yakindu.base.expressions.expressions.BlockExpression
import com.yakindu.base.expressions.expressions.ConditionalExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.ForExpression
import com.yakindu.base.expressions.expressions.IfExpression
import com.yakindu.base.expressions.expressions.LogicalAndExpression
import com.yakindu.base.expressions.expressions.LogicalNotExpression
import com.yakindu.base.expressions.expressions.LogicalOrExpression
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.expressions.expressions.MetaCall
import com.yakindu.base.expressions.expressions.NumericalAddSubtractExpression
import com.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression
import com.yakindu.base.expressions.expressions.NumericalUnaryExpression
import com.yakindu.base.expressions.expressions.ParenthesizedExpression
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.expressions.ReturnExpression
import com.yakindu.base.expressions.expressions.ShiftExpression
import com.yakindu.base.expressions.expressions.SwitchCase
import com.yakindu.base.expressions.expressions.SwitchExpression
import com.yakindu.base.expressions.expressions.TypeCastExpression
import com.yakindu.base.expressions.expressions.WhileExpression
import com.yakindu.base.types.Argument
import com.yakindu.base.types.TypeSpecifier
import org.eclipse.xtext.formatting2.IFormattableDocument
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter

class ExpressionsFormatter extends AbstractEObjectBasedFormatter {
	
	def dispatch void format(AssignmentExpression it, extension IFormattableDocument document) {
		allSemanticRegions.forEach [ region |
			if (it.operator.literal == region.text) {
				region.surround[oneSpace]
			}
		]
		expression.format
		varRef.format
		append[newLine]
	}

	def dispatch void format(ConditionalExpression it, extension IFormattableDocument document) {
		allRegionsFor.keywords("?", ":").forEach[surround[oneSpace]]
		trueCase.format
		falseCase.format
		condition.format
	}

	def dispatch void format(LogicalOrExpression it, extension IFormattableDocument document) {
		regionFor.keyword("||").surround[oneSpace]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(LogicalAndExpression it, extension IFormattableDocument document) {
		regionFor.keyword("&&").surround[oneSpace]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(LogicalNotExpression it, extension IFormattableDocument document) {
		regionFor.keyword("!").surround[noSpace; priority = IHiddenRegionFormatter.LOW_PRIORITY;]
		operand.format
	}

	def dispatch void format(BitwiseOrExpression it, extension IFormattableDocument document) {
		regionFor.keyword("|").surround[oneSpace]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(BitwiseXorExpression it, extension IFormattableDocument document) {
		regionFor.keyword("^").surround[oneSpace]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(BitwiseAndExpression it, extension IFormattableDocument document) {
		regionFor.keyword("&").surround[oneSpace]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(LogicalRelationExpression it, extension IFormattableDocument document) {
		allSemanticRegions.forEach [ region |
			if (it.operator.literal == region.text) {
				region.surround[oneSpace]
			}
		]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(ShiftExpression it, extension IFormattableDocument document) {
		allSemanticRegions.forEach [ region |
			if (it.operator.literal == region.text) {
				region.surround[oneSpace]
			}
		]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(NumericalAddSubtractExpression it, extension IFormattableDocument document) {
		allSemanticRegions.forEach [ region |
			if (it.operator.literal == region.text) {
				region.surround[oneSpace]
			}
		]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(NumericalMultiplyDivideExpression it, extension IFormattableDocument document) {
		allSemanticRegions.forEach [ region |
			if (it.operator.literal == region.text) {
				region.surround[oneSpace]
			}
		]
		leftOperand.format
		rightOperand.format
	}

	def dispatch void format(NumericalUnaryExpression it, extension IFormattableDocument document) {
		allSemanticRegions.forEach [ region |
			if (it.operator.literal == region.text) {
				region.surround[oneSpace]
			}
		]
		operand.format
	}

	def dispatch void format(PrimitiveValueExpression primitiveValueExpression,
		extension IFormattableDocument document) {
	}

	def dispatch void format(BlockExpression it, extension IFormattableDocument document) {
		interior[indent]
		regionFor.keywordPairs('{', '}').forEach [
			key.append[newLine]
			key.prepend[oneSpace]
			value.prepend[newLine]
		]
		expressions.forEach[format append[newLine]]
	}

	def dispatch void format(IfExpression it, extension IFormattableDocument document) {
		regionFor.keyword("if").append[oneSpace]
		regionFor.keyword("else").surround[oneSpace; priority = IHiddenRegionFormatter.HIGH_PRIORITY]
		condition.format
		then.format
		^else.format
		append[newLine]
	}

	def dispatch void format(SwitchExpression it, extension IFormattableDocument document) {
		regionFor.keywordPairs('{', '}').forEach [
			key.append[newLine]
			key.prepend[oneSpace]
			value.prepend[newLine]
		]
		cases.forEach[format]
		regionFor.keyword('default').prepend[newLine]
		regionFor.keyword(':').surround[noSpace].append[newLine]
		^default.format
	}

	def dispatch void format(SwitchCase it, extension IFormattableDocument document) {
		regionFor.keywordPairs('{', '}').forEach [
			key.append[newLine]
			key.prepend[oneSpace]
			value.prepend[newLine]
		]
		interior[indent]
		regionFor.keyword(':').surround[noSpace].append[newLine]
		regionFor.keyword('case').prepend[newLine]
		
	}

	def dispatch void format(EventRaisingExpression it, extension IFormattableDocument document) {
		append[newLine]
	}
	
	def dispatch void format(WhileExpression it, extension IFormattableDocument document) {
		prepend[newLine]
		regionFor.keyword("while").append[oneSpace]
		condition.format
		body.format
		append[newLine]
	}

	def dispatch void format(ForExpression it, extension IFormattableDocument document) {
		prepend[newLine]
		regionFor.keyword("for").append[oneSpace]
		it.varInits.forEach[prepend[noSpace]]
		condition.format
		varUpdates.forEach[prepend[noSpace]]
		body.format
		append[newLine]
	}

	def dispatch void format(com.yakindu.base.types.Property property, extension IFormattableDocument document) {
	}

	def dispatch void format(ReturnExpression returnExpression, extension IFormattableDocument document) {
	}

	def dispatch void format(FeatureCall it, extension IFormattableDocument document) {
		regionFor.keyword(".").surround[noSpace]
		arguments.forEach[format]
		expressions.forEach[format]
		arraySelector.forEach[format]
	}

	def dispatch void format(ElementReferenceExpression elementReferenceExpression,
		extension IFormattableDocument document) {
	}

	def dispatch void format(Argument it, extension IFormattableDocument document) {
		prepend[oneSpace; priority = IHiddenRegionFormatter.LOW_PRIORITY]
		append[noSpace; priority = IHiddenRegionFormatter.LOW_PRIORITY]
		value.format
	}

	def dispatch void format(ParenthesizedExpression parenthesizedExpression, extension IFormattableDocument document) {
	}

	def dispatch void format(TypeSpecifier typeSpecifier, extension IFormattableDocument document) {
	}

	def dispatch void format(PostFixUnaryExpression it, extension IFormattableDocument document) {
		allSemanticRegions.forEach [ region |
			if (it.operator.literal == region.text) {
				region.surround[noSpace]
			}
		]
		operand.format
	}

	def dispatch void format(TypeCastExpression typeCastExpression, extension IFormattableDocument document) {
	}

	def dispatch void format(MetaCall metaCall, extension IFormattableDocument document) {
	}

}
