/*
*
* Copyright (c) 2025 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
grammar InternalExpressions;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package com.yakindu.base.expressions.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package com.yakindu.base.expressions.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import com.yakindu.base.expressions.services.ExpressionsGrammarAccess;

}

@parser::members {

 	private ExpressionsGrammarAccess grammarAccess;

    public InternalExpressionsParser(TokenStream input, ExpressionsGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "Expression";
   	}

   	@Override
   	protected ExpressionsGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleExpression
entryRuleExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpressionRule()); }
	iv_ruleExpression=ruleExpression
	{ $current=$iv_ruleExpression.current; }
	EOF;

// Rule Expression
ruleExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall());
	}
	this_AssignmentExpression_0=ruleAssignmentExpression
	{
		$current = $this_AssignmentExpression_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRuleAssignmentExpression
entryRuleAssignmentExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAssignmentExpressionRule()); }
	iv_ruleAssignmentExpression=ruleAssignmentExpression
	{ $current=$iv_ruleAssignmentExpression.current; }
	EOF;

// Rule AssignmentExpression
ruleAssignmentExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getConditionalExpressionParserRuleCall_0());
		}
		this_ConditionalExpression_0=ruleConditionalExpression
		{
			$current = $this_ConditionalExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleAssignmentOperator
					)
				)
				(
					(
						ruleConditionalExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionVarRefAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignmentOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleAssignmentOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAssignmentExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.AssignmentOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getExpressionConditionalExpressionParserRuleCall_1_0_2_0());
						}
						lv_expression_3_0=ruleConditionalExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAssignmentExpressionRule());
							}
							set(
								$current,
								"expression",
								lv_expression_3_0,
								"com.yakindu.base.expressions.Expressions.ConditionalExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleConditionalExpression
entryRuleConditionalExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConditionalExpressionRule()); }
	iv_ruleConditionalExpression=ruleConditionalExpression
	{ $current=$iv_ruleConditionalExpression.current; }
	EOF;

// Rule ConditionalExpression
ruleConditionalExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getConditionalExpressionAccess().getLogicalOrExpressionParserRuleCall_0());
		}
		this_LogicalOrExpression_0=ruleLogicalOrExpression
		{
			$current = $this_LogicalOrExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				'?'
				(
					(
						ruleLogicalOrExpression
					)
				)
				':'
				(
					(
						ruleLogicalOrExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getConditionalExpressionAccess().getConditionalExpressionConditionAction_1_0_0(),
							$current);
					}
				)
				otherlv_2='?'
				{
					newLeafNode(otherlv_2, grammarAccess.getConditionalExpressionAccess().getQuestionMarkKeyword_1_0_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConditionalExpressionAccess().getTrueCaseLogicalOrExpressionParserRuleCall_1_0_2_0());
						}
						lv_trueCase_3_0=ruleLogicalOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConditionalExpressionRule());
							}
							set(
								$current,
								"trueCase",
								lv_trueCase_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_4=':'
				{
					newLeafNode(otherlv_4, grammarAccess.getConditionalExpressionAccess().getColonKeyword_1_0_3());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConditionalExpressionAccess().getFalseCaseLogicalOrExpressionParserRuleCall_1_0_4_0());
						}
						lv_falseCase_5_0=ruleLogicalOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConditionalExpressionRule());
							}
							set(
								$current,
								"falseCase",
								lv_falseCase_5_0,
								"com.yakindu.base.expressions.Expressions.LogicalOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleLogicalOrExpression
entryRuleLogicalOrExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalOrExpressionRule()); }
	iv_ruleLogicalOrExpression=ruleLogicalOrExpression
	{ $current=$iv_ruleLogicalOrExpression.current; }
	EOF;

// Rule LogicalOrExpression
ruleLogicalOrExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getLogicalAndExpressionParserRuleCall_0());
		}
		this_LogicalAndExpression_0=ruleLogicalAndExpression
		{
			$current = $this_LogicalAndExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleLogicalOrOperator
				(
					(
						ruleLogicalAndExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalOrExpressionAccess().getLogicalOrExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getRightOperandLogicalAndExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalAndExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalOrExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalAndExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalAndExpression
entryRuleLogicalAndExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalAndExpressionRule()); }
	iv_ruleLogicalAndExpression=ruleLogicalAndExpression
	{ $current=$iv_ruleLogicalAndExpression.current; }
	EOF;

// Rule LogicalAndExpression
ruleLogicalAndExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getLogicalNotExpressionParserRuleCall_0());
		}
		this_LogicalNotExpression_0=ruleLogicalNotExpression
		{
			$current = $this_LogicalNotExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleLogicalAndOperator
				(
					(
						ruleLogicalNotExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalAndExpressionAccess().getLogicalAndExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalAndOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getRightOperandLogicalNotExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalNotExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalAndExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalNotExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalNotExpression
entryRuleLogicalNotExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalNotExpressionRule()); }
	iv_ruleLogicalNotExpression=ruleLogicalNotExpression
	{ $current=$iv_ruleLogicalNotExpression.current; }
	EOF;

// Rule LogicalNotExpression
ruleLogicalNotExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getBitwiseOrExpressionParserRuleCall_0());
		}
		this_BitwiseOrExpression_0=ruleBitwiseOrExpression
		{
			$current = $this_BitwiseOrExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			((
				(
				)
				ruleLogicalNotOperator
				(
					(
						ruleBitwiseOrExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getLogicalNotExpressionAccess().getLogicalNotExpressionAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalNotOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getOperandBitwiseOrExpressionParserRuleCall_1_0_2_0());
						}
						lv_operand_3_0=ruleBitwiseOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalNotExpressionRule());
							}
							set(
								$current,
								"operand",
								lv_operand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleBitwiseOrExpression
entryRuleBitwiseOrExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseOrExpressionRule()); }
	iv_ruleBitwiseOrExpression=ruleBitwiseOrExpression
	{ $current=$iv_ruleBitwiseOrExpression.current; }
	EOF;

// Rule BitwiseOrExpression
ruleBitwiseOrExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseXorExpressionParserRuleCall_0());
		}
		this_BitwiseXorExpression_0=ruleBitwiseXorExpression
		{
			$current = $this_BitwiseXorExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseOrOperator
				(
					(
						ruleBitwiseXorExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandBitwiseXorExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleBitwiseXorExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseOrExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseXorExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleBitwiseXorExpression
entryRuleBitwiseXorExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseXorExpressionRule()); }
	iv_ruleBitwiseXorExpression=ruleBitwiseXorExpression
	{ $current=$iv_ruleBitwiseXorExpression.current; }
	EOF;

// Rule BitwiseXorExpression
ruleBitwiseXorExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseAndExpressionParserRuleCall_0());
		}
		this_BitwiseAndExpression_0=ruleBitwiseAndExpression
		{
			$current = $this_BitwiseAndExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseXOrOperator
				(
					(
						ruleBitwiseAndExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXorExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXOrOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseXOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandBitwiseAndExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleBitwiseAndExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseXorExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseAndExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleBitwiseAndExpression
entryRuleBitwiseAndExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseAndExpressionRule()); }
	iv_ruleBitwiseAndExpression=ruleBitwiseAndExpression
	{ $current=$iv_ruleBitwiseAndExpression.current; }
	EOF;

// Rule BitwiseAndExpression
ruleBitwiseAndExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getLogicalRelationExpressionParserRuleCall_0());
		}
		this_LogicalRelationExpression_0=ruleLogicalRelationExpression
		{
			$current = $this_LogicalRelationExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseAndOperator
				(
					(
						ruleLogicalRelationExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseAndOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandLogicalRelationExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalRelationExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseAndExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalRelationExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalRelationExpression
entryRuleLogicalRelationExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalRelationExpressionRule()); }
	iv_ruleLogicalRelationExpression=ruleLogicalRelationExpression
	{ $current=$iv_ruleLogicalRelationExpression.current; }
	EOF;

// Rule LogicalRelationExpression
ruleLogicalRelationExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getShiftExpressionParserRuleCall_0());
		}
		this_ShiftExpression_0=ruleShiftExpression
		{
			$current = $this_ShiftExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleRelationalOperator
					)
				)
				(
					(
						ruleShiftExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalRelationExpressionAccess().getLogicalRelationExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getOperatorRelationalOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleRelationalOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalRelationExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.RelationalOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandShiftExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleShiftExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalRelationExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.ShiftExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleShiftExpression
entryRuleShiftExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getShiftExpressionRule()); }
	iv_ruleShiftExpression=ruleShiftExpression
	{ $current=$iv_ruleShiftExpression.current; }
	EOF;

// Rule ShiftExpression
ruleShiftExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getShiftExpressionAccess().getNumericalAddSubtractExpressionParserRuleCall_0());
		}
		this_NumericalAddSubtractExpression_0=ruleNumericalAddSubtractExpression
		{
			$current = $this_NumericalAddSubtractExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleShiftOperator
					)
				)
				(
					(
						ruleNumericalAddSubtractExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getShiftExpressionAccess().getShiftExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getShiftExpressionAccess().getOperatorShiftOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleShiftOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getShiftExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.ShiftOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getShiftExpressionAccess().getRightOperandNumericalAddSubtractExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalAddSubtractExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getShiftExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalAddSubtractExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalAddSubtractExpression
entryRuleNumericalAddSubtractExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionRule()); }
	iv_ruleNumericalAddSubtractExpression=ruleNumericalAddSubtractExpression
	{ $current=$iv_ruleNumericalAddSubtractExpression.current; }
	EOF;

// Rule NumericalAddSubtractExpression
ruleNumericalAddSubtractExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalMultiplyDivideExpressionParserRuleCall_0());
		}
		this_NumericalMultiplyDivideExpression_0=ruleNumericalMultiplyDivideExpression
		{
			$current = $this_NumericalMultiplyDivideExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleAdditiveOperator
					)
				)
				(
					(
						ruleNumericalMultiplyDivideExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalAddSubtractExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAdditiveOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleAdditiveOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalAddSubtractExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.AdditiveOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandNumericalMultiplyDivideExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalMultiplyDivideExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalAddSubtractExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalMultiplyDivideExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalMultiplyDivideExpression
entryRuleNumericalMultiplyDivideExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionRule()); }
	iv_ruleNumericalMultiplyDivideExpression=ruleNumericalMultiplyDivideExpression
	{ $current=$iv_ruleNumericalMultiplyDivideExpression.current; }
	EOF;

// Rule NumericalMultiplyDivideExpression
ruleNumericalMultiplyDivideExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalUnaryExpressionParserRuleCall_0());
		}
		this_NumericalUnaryExpression_0=ruleNumericalUnaryExpression
		{
			$current = $this_NumericalUnaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleMultiplicativeOperator
					)
				)
				(
					(
						ruleNumericalUnaryExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalMultiplyDivideExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorMultiplicativeOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleMultiplicativeOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalMultiplyDivideExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.MultiplicativeOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandNumericalUnaryExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalUnaryExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalMultiplyDivideExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalUnaryExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalUnaryExpression
entryRuleNumericalUnaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalUnaryExpressionRule()); }
	iv_ruleNumericalUnaryExpression=ruleNumericalUnaryExpression
	{ $current=$iv_ruleNumericalUnaryExpression.current; }
	EOF;

// Rule NumericalUnaryExpression
ruleNumericalUnaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getPostFixUnaryExpressionParserRuleCall_0());
		}
		this_PostFixUnaryExpression_0=rulePostFixUnaryExpression
		{
			$current = $this_PostFixUnaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			((
				(
				)
				(
					(
						ruleUnaryOperator
					)
				)
				(
					(
						rulePostFixUnaryExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getNumericalUnaryExpressionAccess().getNumericalUnaryExpressionAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorUnaryOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleUnaryOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalUnaryExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.UnaryOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getOperandPostFixUnaryExpressionParserRuleCall_1_0_2_0());
						}
						lv_operand_3_0=rulePostFixUnaryExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalUnaryExpressionRule());
							}
							set(
								$current,
								"operand",
								lv_operand_3_0,
								"com.yakindu.base.expressions.Expressions.PostFixUnaryExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRulePostFixUnaryExpression
entryRulePostFixUnaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPostFixUnaryExpressionRule()); }
	iv_rulePostFixUnaryExpression=rulePostFixUnaryExpression
	{ $current=$iv_rulePostFixUnaryExpression.current; }
	EOF;

// Rule PostFixUnaryExpression
rulePostFixUnaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPostFixUnaryExpressionAccess().getTypeCastExpressionParserRuleCall_0());
		}
		this_TypeCastExpression_0=ruleTypeCastExpression
		{
			$current = $this_TypeCastExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						rulePostFixOperator
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getPostFixUnaryExpressionAccess().getPostFixUnaryExpressionOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorPostFixOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=rulePostFixOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPostFixUnaryExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.PostFixOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleTypeCastExpression
entryRuleTypeCastExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeCastExpressionRule()); }
	iv_ruleTypeCastExpression=ruleTypeCastExpression
	{ $current=$iv_ruleTypeCastExpression.current; }
	EOF;

// Rule TypeCastExpression
ruleTypeCastExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTypeCastExpressionAccess().getFeatureCallParserRuleCall_0());
		}
		this_FeatureCall_0=ruleFeatureCall
		{
			$current = $this_FeatureCall_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
					(
					)
					'as'
				)
				(
					(
						ruleTypeSpecifier
					)
				)
			)
			)=>
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getTypeCastExpressionAccess().getTypeCastExpressionOperandAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='as'
					{
						newLeafNode(otherlv_2, grammarAccess.getTypeCastExpressionAccess().getAsKeyword_1_0_0_1());
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_1_0_1_0());
						}
						lv_typeSpecifier_3_0=ruleTypeSpecifier
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getTypeCastExpressionRule());
							}
							set(
								$current,
								"typeSpecifier",
								lv_typeSpecifier_3_0,
								"com.yakindu.base.expressions.Expressions.TypeSpecifier");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleFeatureCall
entryRuleFeatureCall returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFeatureCallRule()); }
	iv_ruleFeatureCall=ruleFeatureCall
	{ $current=$iv_ruleFeatureCall.current; }
	EOF;

// Rule FeatureCall
ruleFeatureCall returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getFeatureCallAccess().getPrimaryExpressionParserRuleCall_0());
		}
		this_PrimaryExpression_0=rulePrimaryExpression
		{
			$current = $this_PrimaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
					(
						(
						)
						(
							('.')=>
							'.'
						)
					)
					    |
					(
						(
						)
						'.@'
					)
				)
				(
					(
						ruleRefIDWithKeywords
					)
				)
				(
					(
						(
							((
								'('
							)
							)=>
							(
								'('
							)
						)
						(
							(
								(
									ruleArgument
								)
							)
							(
								','
								(
									(
										ruleArgument
									)
								)
							)*
						)?
						')'
					)
					    |
					(
						(
							((
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
						)
						(
							((
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
						)*
					)
				)?
			)
			)=>
			(
				(
					(
						(
							{
								$current = forceCreateModelElementAndSet(
									grammarAccess.getFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0_0(),
									$current);
							}
						)
						(
							('.')=>
							otherlv_2='.'
							{
								newLeafNode(otherlv_2, grammarAccess.getFeatureCallAccess().getFullStopKeyword_1_0_0_0_1());
							}
						)
					)
					    |
					(
						(
							{
								$current = forceCreateModelElementAndSet(
									grammarAccess.getFeatureCallAccess().getMetaCallOwnerAction_1_0_0_1_0(),
									$current);
							}
						)
						otherlv_4='.@'
						{
							newLeafNode(otherlv_4, grammarAccess.getFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_0_1_1());
						}
					)
				)
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getFeatureCallRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getFeatureCallAccess().getFeatureEObjectCrossReference_1_0_1_0());
						}
						ruleRefIDWithKeywords
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						(
							((
								'('
							)
							)=>
							(
								lv_operationCall_6_0='('
								{
									newLeafNode(lv_operationCall_6_0, grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0());
								}
								{
									if ($current==null) {
										$current = createModelElement(grammarAccess.getFeatureCallRule());
									}
									setWithLastConsumed($current, "operationCall", lv_operationCall_6_0 != null, "(");
								}
							)
						)
						(
							(
								(
									{
										newCompositeNode(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_0_0());
									}
									lv_arguments_7_0=ruleArgument
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
										}
										add(
											$current,
											"arguments",
											lv_arguments_7_0,
											"com.yakindu.base.expressions.Expressions.Argument");
										afterParserOrEnumRuleCall();
									}
								)
							)
							(
								otherlv_8=','
								{
									newLeafNode(otherlv_8, grammarAccess.getFeatureCallAccess().getCommaKeyword_1_0_2_0_1_1_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_1_1_0());
										}
										lv_arguments_9_0=ruleArgument
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arguments",
												lv_arguments_9_0,
												"com.yakindu.base.expressions.Expressions.Argument");
											afterParserOrEnumRuleCall();
										}
									)
								)
							)*
						)?
						otherlv_10=')'
						{
							newLeafNode(otherlv_10, grammarAccess.getFeatureCallAccess().getRightParenthesisKeyword_1_0_2_0_2());
						}
					)
					    |
					(
						(
							((
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								(
									(
										lv_arrayAccess_11_0='['
										{
											newLeafNode(lv_arrayAccess_11_0, grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getFeatureCallRule());
											}
											setWithLastConsumed($current, "arrayAccess", lv_arrayAccess_11_0 != null, "[");
										}
									)
								)
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_0_0_1_0());
										}
										lv_arraySelector_12_0=ruleExpression
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arraySelector",
												lv_arraySelector_12_0,
												"com.yakindu.base.expressions.Expressions.Expression");
											afterParserOrEnumRuleCall();
										}
									)
								)
								otherlv_13=']'
								{
									newLeafNode(otherlv_13, grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_0_0_2());
								}
							)
						)
						(
							((
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								otherlv_14='['
								{
									newLeafNode(otherlv_14, grammarAccess.getFeatureCallAccess().getLeftSquareBracketKeyword_1_0_2_1_1_0_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_1_0_1_0());
										}
										lv_arraySelector_15_0=ruleExpression
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arraySelector",
												lv_arraySelector_15_0,
												"com.yakindu.base.expressions.Expressions.Expression");
											afterParserOrEnumRuleCall();
										}
									)
								)
								otherlv_16=']'
								{
									newLeafNode(otherlv_16, grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_1_0_2());
								}
							)
						)*
					)
				)?
			)
		)*
	)
;

// Entry rule entryRulePrimaryExpression
entryRulePrimaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimaryExpressionRule()); }
	iv_rulePrimaryExpression=rulePrimaryExpression
	{ $current=$iv_rulePrimaryExpression.current; }
	EOF;

// Rule PrimaryExpression
rulePrimaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getElementReferenceExpressionParserRuleCall_0());
		}
		this_ElementReferenceExpression_0=ruleElementReferenceExpression
		{
			$current = $this_ElementReferenceExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getPrimitiveValueExpressionParserRuleCall_1());
		}
		this_PrimitiveValueExpression_1=rulePrimitiveValueExpression
		{
			$current = $this_PrimitiveValueExpression_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getParenthesizedExpressionParserRuleCall_2());
		}
		this_ParenthesizedExpression_2=ruleParenthesizedExpression
		{
			$current = $this_ParenthesizedExpression_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getIfExpressionParserRuleCall_3());
		}
		this_IfExpression_3=ruleIfExpression
		{
			$current = $this_IfExpression_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getReturnExpressionParserRuleCall_4());
		}
		this_ReturnExpression_4=ruleReturnExpression
		{
			$current = $this_ReturnExpression_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getSwitchExpressionParserRuleCall_5());
		}
		this_SwitchExpression_5=ruleSwitchExpression
		{
			$current = $this_SwitchExpression_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getInitializationExpressionParserRuleCall_6());
		}
		this_InitializationExpression_6=ruleInitializationExpression
		{
			$current = $this_InitializationExpression_6.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleElementReferenceExpression
entryRuleElementReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getElementReferenceExpressionRule()); }
	iv_ruleElementReferenceExpression=ruleElementReferenceExpression
	{ $current=$iv_ruleElementReferenceExpression.current; }
	EOF;

// Rule ElementReferenceExpression
ruleElementReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getElementReferenceExpressionAccess().getElementReferenceExpressionAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectCrossReference_1_0());
				}
				ruleRefIDWithKeywords
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(
					((
						'('
					)
					)=>
					(
						lv_operationCall_2_0='('
						{
							newLeafNode(lv_operationCall_2_0, grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
							}
							setWithLastConsumed($current, "operationCall", lv_operationCall_2_0 != null, "(");
						}
					)
				)
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_0_0());
							}
							lv_arguments_3_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_3_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_4=','
						{
							newLeafNode(otherlv_4, grammarAccess.getElementReferenceExpressionAccess().getCommaKeyword_2_0_1_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_1_1_0());
								}
								lv_arguments_5_0=ruleArgument
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arguments",
										lv_arguments_5_0,
										"com.yakindu.base.expressions.Expressions.Argument");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_6=')'
				{
					newLeafNode(otherlv_6, grammarAccess.getElementReferenceExpressionAccess().getRightParenthesisKeyword_2_0_2());
				}
			)
			    |
			(
				(
					((
						(
							(
								'['
							)
						)
						(
							(
								ruleExpression
							)
						)
						']'
					)
					)=>
					(
						(
							(
								lv_arrayAccess_7_0='['
								{
									newLeafNode(lv_arrayAccess_7_0, grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0());
								}
								{
									if ($current==null) {
										$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
									}
									setWithLastConsumed($current, "arrayAccess", lv_arrayAccess_7_0 != null, "[");
								}
							)
						)
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_0_0_1_0());
								}
								lv_arraySelector_8_0=ruleExpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arraySelector",
										lv_arraySelector_8_0,
										"com.yakindu.base.expressions.Expressions.Expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
						otherlv_9=']'
						{
							newLeafNode(otherlv_9, grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_0_0_2());
						}
					)
				)
				(
					((
						'['
						(
							(
								ruleExpression
							)
						)
						']'
					)
					)=>
					(
						otherlv_10='['
						{
							newLeafNode(otherlv_10, grammarAccess.getElementReferenceExpressionAccess().getLeftSquareBracketKeyword_2_1_1_0_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_1_0_1_0());
								}
								lv_arraySelector_11_0=ruleExpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arraySelector",
										lv_arraySelector_11_0,
										"com.yakindu.base.expressions.Expressions.Expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
						otherlv_12=']'
						{
							newLeafNode(otherlv_12, grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_1_0_2());
						}
					)
				)*
			)
		)?
	)
;

// Entry rule entryRulePrimitiveValueExpression
entryRulePrimitiveValueExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimitiveValueExpressionRule()); }
	iv_rulePrimitiveValueExpression=rulePrimitiveValueExpression
	{ $current=$iv_rulePrimitiveValueExpression.current; }
	EOF;

// Rule PrimitiveValueExpression
rulePrimitiveValueExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPrimitiveValueExpressionAccess().getPrimitiveValueExpressionAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getPrimitiveValueExpressionAccess().getValueLiteralParserRuleCall_1_0());
				}
				lv_value_1_0=ruleLiteral
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPrimitiveValueExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.Literal");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleIfExpression
entryRuleIfExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIfExpressionRule()); }
	iv_ruleIfExpression=ruleIfExpression
	{ $current=$iv_ruleIfExpression.current; }
	EOF;

// Rule IfExpression
ruleIfExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getIfExpressionAccess().getIfExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='if'
		{
			newLeafNode(otherlv_1, grammarAccess.getIfExpressionAccess().getIfKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getIfExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getIfExpressionAccess().getConditionExpressionParserRuleCall_3_0());
				}
				lv_condition_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getIfExpressionRule());
					}
					set(
						$current,
						"condition",
						lv_condition_3_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getIfExpressionAccess().getRightParenthesisKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getIfExpressionAccess().getThenBlockExpressionParserRuleCall_5_0());
				}
				lv_then_5_0=ruleBlockExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getIfExpressionRule());
					}
					set(
						$current,
						"then",
						lv_then_5_0,
						"com.yakindu.base.expressions.Expressions.BlockExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				('else')=>
				otherlv_6='else'
				{
					newLeafNode(otherlv_6, grammarAccess.getIfExpressionAccess().getElseKeyword_6_0());
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getIfExpressionAccess().getElseBlockExpressionParserRuleCall_6_1_0());
					}
					lv_else_7_0=ruleBlockExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getIfExpressionRule());
						}
						set(
							$current,
							"else",
							lv_else_7_0,
							"com.yakindu.base.expressions.Expressions.BlockExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleSwitchExpression
entryRuleSwitchExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSwitchExpressionRule()); }
	iv_ruleSwitchExpression=ruleSwitchExpression
	{ $current=$iv_ruleSwitchExpression.current; }
	EOF;

// Rule SwitchExpression
ruleSwitchExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSwitchExpressionAccess().getSwitchExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='switch'
		{
			newLeafNode(otherlv_1, grammarAccess.getSwitchExpressionAccess().getSwitchKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getSwitchExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSwitchExpressionAccess().getSwitchExpressionOrBlockExpressionParserRuleCall_3_0());
				}
				lv_switch_3_0=ruleExpressionOrBlockExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSwitchExpressionRule());
					}
					set(
						$current,
						"switch",
						lv_switch_3_0,
						"com.yakindu.base.expressions.Expressions.ExpressionOrBlockExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getSwitchExpressionAccess().getRightParenthesisKeyword_4());
		}
		otherlv_5='{'
		{
			newLeafNode(otherlv_5, grammarAccess.getSwitchExpressionAccess().getLeftCurlyBracketKeyword_5());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSwitchExpressionAccess().getCasesSwitchCaseParserRuleCall_6_0());
				}
				lv_cases_6_0=ruleSwitchCase
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSwitchExpressionRule());
					}
					add(
						$current,
						"cases",
						lv_cases_6_0,
						"com.yakindu.base.expressions.Expressions.SwitchCase");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			otherlv_7='default'
			{
				newLeafNode(otherlv_7, grammarAccess.getSwitchExpressionAccess().getDefaultKeyword_7_0());
			}
			otherlv_8=':'
			{
				newLeafNode(otherlv_8, grammarAccess.getSwitchExpressionAccess().getColonKeyword_7_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getSwitchExpressionAccess().getDefaultExpressionOrBlockExpressionParserRuleCall_7_2_0());
					}
					lv_default_9_0=ruleExpressionOrBlockExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSwitchExpressionRule());
						}
						set(
							$current,
							"default",
							lv_default_9_0,
							"com.yakindu.base.expressions.Expressions.ExpressionOrBlockExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_10='}'
		{
			newLeafNode(otherlv_10, grammarAccess.getSwitchExpressionAccess().getRightCurlyBracketKeyword_8());
		}
	)
;

// Entry rule entryRuleSwitchCase
entryRuleSwitchCase returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSwitchCaseRule()); }
	iv_ruleSwitchCase=ruleSwitchCase
	{ $current=$iv_ruleSwitchCase.current; }
	EOF;

// Rule SwitchCase
ruleSwitchCase returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSwitchCaseAccess().getSwitchCaseAction_0(),
					$current);
			}
		)
		otherlv_1='case'
		{
			newLeafNode(otherlv_1, grammarAccess.getSwitchCaseAccess().getCaseKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSwitchCaseAccess().getCaseExpressionParserRuleCall_2_0());
				}
				lv_case_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSwitchCaseRule());
					}
					set(
						$current,
						"case",
						lv_case_2_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3=':'
			{
				newLeafNode(otherlv_3, grammarAccess.getSwitchCaseAccess().getColonKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getSwitchCaseAccess().getThenExpressionOrBlockExpressionParserRuleCall_3_1_0());
					}
					lv_then_4_0=ruleExpressionOrBlockExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSwitchCaseRule());
						}
						set(
							$current,
							"then",
							lv_then_4_0,
							"com.yakindu.base.expressions.Expressions.ExpressionOrBlockExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
	)
;

// Entry rule entryRuleReturnExpression
entryRuleReturnExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReturnExpressionRule()); }
	iv_ruleReturnExpression=ruleReturnExpression
	{ $current=$iv_ruleReturnExpression.current; }
	EOF;

// Rule ReturnExpression
ruleReturnExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getReturnExpressionAccess().getReturnExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='return'
		{
			newLeafNode(otherlv_1, grammarAccess.getReturnExpressionAccess().getReturnKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getReturnExpressionAccess().getExpressionConditionalExpressionParserRuleCall_2_0());
				}
				lv_expression_2_0=ruleConditionalExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getReturnExpressionRule());
					}
					set(
						$current,
						"expression",
						lv_expression_2_0,
						"com.yakindu.base.expressions.Expressions.ConditionalExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleInitializationExpression
entryRuleInitializationExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getInitializationExpressionRule()); }
	iv_ruleInitializationExpression=ruleInitializationExpression
	{ $current=$iv_ruleInitializationExpression.current; }
	EOF;

// Rule InitializationExpression
ruleInitializationExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getInitializationExpressionAccess().getInitializationExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getInitializationExpressionAccess().getLeftCurlyBracketKeyword_1());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_0());
					}
					lv_arguments_2_0=ruleArgument
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getInitializationExpressionRule());
						}
						add(
							$current,
							"arguments",
							lv_arguments_2_0,
							"com.yakindu.base.expressions.Expressions.Argument");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_3=','
				{
					newLeafNode(otherlv_3, grammarAccess.getInitializationExpressionAccess().getCommaKeyword_2_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_1_1_0());
						}
						lv_arguments_4_0=ruleArgument
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getInitializationExpressionRule());
							}
							add(
								$current,
								"arguments",
								lv_arguments_4_0,
								"com.yakindu.base.expressions.Expressions.Argument");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_5='}'
		{
			newLeafNode(otherlv_5, grammarAccess.getInitializationExpressionAccess().getRightCurlyBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleExpressionOrBlockExpression
entryRuleExpressionOrBlockExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpressionOrBlockExpressionRule()); }
	iv_ruleExpressionOrBlockExpression=ruleExpressionOrBlockExpression
	{ $current=$iv_ruleExpressionOrBlockExpression.current; }
	EOF;

// Rule ExpressionOrBlockExpression
ruleExpressionOrBlockExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getExpressionOrBlockExpressionAccess().getExpressionParserRuleCall_0());
		}
		this_Expression_0=ruleExpression
		{
			$current = $this_Expression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			(ruleBlockExpression)=>
			{
				newCompositeNode(grammarAccess.getExpressionOrBlockExpressionAccess().getBlockExpressionParserRuleCall_1());
			}
			this_BlockExpression_1=ruleBlockExpression
			{
				$current = $this_BlockExpression_1.current;
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleBlockExpression
entryRuleBlockExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBlockExpressionRule()); }
	iv_ruleBlockExpression=ruleBlockExpression
	{ $current=$iv_ruleBlockExpression.current; }
	EOF;

// Rule BlockExpression
ruleBlockExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBlockExpressionAccess().getBlockExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getBlockExpressionAccess().getLeftCurlyBracketKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getBlockExpressionAccess().getExpressionsExpressionParserRuleCall_2_0());
				}
				lv_expressions_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getBlockExpressionRule());
					}
					add(
						$current,
						"expressions",
						lv_expressions_2_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_3='}'
		{
			newLeafNode(otherlv_3, grammarAccess.getBlockExpressionAccess().getRightCurlyBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleArgument
entryRuleArgument returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getArgumentRule()); }
	iv_ruleArgument=ruleArgument
	{ $current=$iv_ruleArgument.current; }
	EOF;

// Rule Argument
ruleArgument returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getArgumentRule());
						}
					}
					otherlv_0=RULE_ID
					{
						newLeafNode(otherlv_0, grammarAccess.getArgumentAccess().getParameterTypedDeclarationCrossReference_0_0_0());
					}
				)
			)
			otherlv_1='='
			{
				newLeafNode(otherlv_1, grammarAccess.getArgumentAccess().getEqualsSignKeyword_0_1());
			}
		)?
		(
			((
				(
					(
						rulePrimitiveValueExpression
					)
				)
				':'
			)
			)=>
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getArgumentAccess().getKeyPrimitiveValueExpressionParserRuleCall_1_0_0_0());
						}
						lv_key_2_0=rulePrimitiveValueExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getArgumentRule());
							}
							set(
								$current,
								"key",
								lv_key_2_0,
								"com.yakindu.base.expressions.Expressions.PrimitiveValueExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_3=':'
				{
					newLeafNode(otherlv_3, grammarAccess.getArgumentAccess().getColonKeyword_1_0_1());
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getArgumentAccess().getValueConditionalExpressionParserRuleCall_2_0());
				}
				lv_value_4_0=ruleConditionalExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getArgumentRule());
					}
					set(
						$current,
						"value",
						lv_value_4_0,
						"com.yakindu.base.expressions.Expressions.ConditionalExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleParenthesizedExpression
entryRuleParenthesizedExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getParenthesizedExpressionRule()); }
	iv_ruleParenthesizedExpression=ruleParenthesizedExpression
	{ $current=$iv_ruleParenthesizedExpression.current; }
	EOF;

// Rule ParenthesizedExpression
ruleParenthesizedExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getParenthesizedExpressionAccess().getParenthesizedExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getParenthesizedExpressionAccess().getExpressionExpressionParserRuleCall_2_0());
				}
				lv_expression_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getParenthesizedExpressionRule());
					}
					set(
						$current,
						"expression",
						lv_expression_2_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3=')'
		{
			newLeafNode(otherlv_3, grammarAccess.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3());
		}
	)
;

// Entry rule entryRuleTypeSpecifier
entryRuleTypeSpecifier returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeSpecifierRule()); }
	iv_ruleTypeSpecifier=ruleTypeSpecifier
	{ $current=$iv_ruleTypeSpecifier.current; }
	EOF;

// Rule TypeSpecifier
ruleTypeSpecifier returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTypeSpecifierRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeTypeCrossReference_0_0());
				}
				ruleQID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			((
				'<'
				(
					(
						(
							ruleTypeSpecifier
						)
					)
					(
						','
						(
							(
								ruleTypeSpecifier
							)
						)
					)*
				)?
				'>'
			)
			)=>
			(
				otherlv_1='<'
				{
					newLeafNode(otherlv_1, grammarAccess.getTypeSpecifierAccess().getLessThanSignKeyword_1_0_0());
				}
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_0_0());
							}
							lv_typeArguments_2_0=ruleTypeSpecifier
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getTypeSpecifierRule());
								}
								add(
									$current,
									"typeArguments",
									lv_typeArguments_2_0,
									"com.yakindu.base.expressions.Expressions.TypeSpecifier");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_3=','
						{
							newLeafNode(otherlv_3, grammarAccess.getTypeSpecifierAccess().getCommaKeyword_1_0_1_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_1_1_0());
								}
								lv_typeArguments_4_0=ruleTypeSpecifier
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getTypeSpecifierRule());
									}
									add(
										$current,
										"typeArguments",
										lv_typeArguments_4_0,
										"com.yakindu.base.expressions.Expressions.TypeSpecifier");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_5='>'
				{
					newLeafNode(otherlv_5, grammarAccess.getTypeSpecifierAccess().getGreaterThanSignKeyword_1_0_2());
				}
			)
		)?
	)
;

// Entry rule entryRuleQID
entryRuleQID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getQIDRule()); }
	iv_ruleQID=ruleQID
	{ $current=$iv_ruleQID.current.getText(); }
	EOF;

// Rule QID
ruleQID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getQIDAccess().getIDTerminalRuleCall_0());
		}
		(
			(
				('.')=>
				kw='.'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getQIDAccess().getFullStopKeyword_1_0());
				}
			)
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getQIDAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleReferenceKeywords
entryRuleReferenceKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getReferenceKeywordsRule()); }
	iv_ruleReferenceKeywords=ruleReferenceKeywords
	{ $current=$iv_ruleReferenceKeywords.current.getText(); }
	EOF;

// Rule ReferenceKeywords
ruleReferenceKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='as'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getAsKeyword_0());
		}
		    |
		kw='default'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getDefaultKeyword_1());
		}
		    |
		kw='case'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getCaseKeyword_2());
		}
		    |
		kw='else'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getElseKeyword_3());
		}
	)
;

// Entry rule entryRuleRefIDWithKeywords
entryRuleRefIDWithKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getRefIDWithKeywordsRule()); }
	iv_ruleRefIDWithKeywords=ruleRefIDWithKeywords
	{ $current=$iv_ruleRefIDWithKeywords.current.getText(); }
	EOF;

// Rule RefIDWithKeywords
ruleRefIDWithKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getRefIDWithKeywordsAccess().getIDTerminalRuleCall_0());
		}
		    |
		{
			newCompositeNode(grammarAccess.getRefIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1());
		}
		this_ReferenceKeywords_1=ruleReferenceKeywords
		{
			$current.merge(this_ReferenceKeywords_1);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleLiteral
entryRuleLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLiteralRule()); }
	iv_ruleLiteral=ruleLiteral
	{ $current=$iv_ruleLiteral.current; }
	EOF;

// Rule Literal
ruleLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getBoolLiteralParserRuleCall_0());
		}
		this_BoolLiteral_0=ruleBoolLiteral
		{
			$current = $this_BoolLiteral_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getIntLiteralParserRuleCall_1());
		}
		this_IntLiteral_1=ruleIntLiteral
		{
			$current = $this_IntLiteral_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getHexLiteralParserRuleCall_2());
		}
		this_HexLiteral_2=ruleHexLiteral
		{
			$current = $this_HexLiteral_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getBinaryLiteralParserRuleCall_3());
		}
		this_BinaryLiteral_3=ruleBinaryLiteral
		{
			$current = $this_BinaryLiteral_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getDoubleLiteralParserRuleCall_4());
		}
		this_DoubleLiteral_4=ruleDoubleLiteral
		{
			$current = $this_DoubleLiteral_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getFloatLiteralParserRuleCall_5());
		}
		this_FloatLiteral_5=ruleFloatLiteral
		{
			$current = $this_FloatLiteral_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_6());
		}
		this_StringLiteral_6=ruleStringLiteral
		{
			$current = $this_StringLiteral_6.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_7());
		}
		this_NullLiteral_7=ruleNullLiteral
		{
			$current = $this_NullLiteral_7.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleBoolLiteral
entryRuleBoolLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBoolLiteralRule()); }
	iv_ruleBoolLiteral=ruleBoolLiteral
	{ $current=$iv_ruleBoolLiteral.current; }
	EOF;

// Rule BoolLiteral
ruleBoolLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBoolLiteralAccess().getBoolLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_BOOL
				{
					newLeafNode(lv_value_1_0, grammarAccess.getBoolLiteralAccess().getValueBOOLTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getBoolLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.BOOL");
				}
			)
		)
	)
;

// Entry rule entryRuleIntLiteral
entryRuleIntLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntLiteralRule()); }
	iv_ruleIntLiteral=ruleIntLiteral
	{ $current=$iv_ruleIntLiteral.current; }
	EOF;

// Rule IntLiteral
ruleIntLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getIntLiteralAccess().getIntLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_LONG
				{
					newLeafNode(lv_value_1_0, grammarAccess.getIntLiteralAccess().getValueLONGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.LONG");
				}
			)
		)
	)
;

// Entry rule entryRuleDoubleLiteral
entryRuleDoubleLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDoubleLiteralRule()); }
	iv_ruleDoubleLiteral=ruleDoubleLiteral
	{ $current=$iv_ruleDoubleLiteral.current; }
	EOF;

// Rule DoubleLiteral
ruleDoubleLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDoubleLiteralAccess().getDoubleLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_DOUBLE
				{
					newLeafNode(lv_value_1_0, grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDoubleLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.DOUBLE");
				}
			)
		)
	)
;

// Entry rule entryRuleFloatLiteral
entryRuleFloatLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFloatLiteralRule()); }
	iv_ruleFloatLiteral=ruleFloatLiteral
	{ $current=$iv_ruleFloatLiteral.current; }
	EOF;

// Rule FloatLiteral
ruleFloatLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getFloatLiteralAccess().getFloatLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_FLOAT
				{
					newLeafNode(lv_value_1_0, grammarAccess.getFloatLiteralAccess().getValueFLOATTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFloatLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.FLOAT");
				}
			)
		)
	)
;

// Entry rule entryRuleHexLiteral
entryRuleHexLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getHexLiteralRule()); }
	iv_ruleHexLiteral=ruleHexLiteral
	{ $current=$iv_ruleHexLiteral.current; }
	EOF;

// Rule HexLiteral
ruleHexLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getHexLiteralAccess().getHexLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_HEX
				{
					newLeafNode(lv_value_1_0, grammarAccess.getHexLiteralAccess().getValueHEXTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getHexLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.HEX");
				}
			)
		)
	)
;

// Entry rule entryRuleBinaryLiteral
entryRuleBinaryLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBinaryLiteralRule()); }
	iv_ruleBinaryLiteral=ruleBinaryLiteral
	{ $current=$iv_ruleBinaryLiteral.current; }
	EOF;

// Rule BinaryLiteral
ruleBinaryLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBinaryLiteralAccess().getBinaryLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_BINARY
				{
					newLeafNode(lv_value_1_0, grammarAccess.getBinaryLiteralAccess().getValueBINARYTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getBinaryLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.BINARY");
				}
			)
		)
	)
;

// Entry rule entryRuleStringLiteral
entryRuleStringLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStringLiteralRule()); }
	iv_ruleStringLiteral=ruleStringLiteral
	{ $current=$iv_ruleStringLiteral.current; }
	EOF;

// Rule StringLiteral
ruleStringLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStringLiteralAccess().getStringLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_STRING
				{
					newLeafNode(lv_value_1_0, grammarAccess.getStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStringLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.STRING");
				}
			)
		)
	)
;

// Entry rule entryRuleNullLiteral
entryRuleNullLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNullLiteralRule()); }
	iv_ruleNullLiteral=ruleNullLiteral
	{ $current=$iv_ruleNullLiteral.current; }
	EOF;

// Rule NullLiteral
ruleNullLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getNullLiteralAccess().getNullLiteralAction_0(),
					$current);
			}
		)
		otherlv_1='null'
		{
			newLeafNode(otherlv_1, grammarAccess.getNullLiteralAccess().getNullKeyword_1());
		}
	)
;

// Entry rule entryRuleLogicalAndOperator
entryRuleLogicalAndOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalAndOperatorRule()); }
	iv_ruleLogicalAndOperator=ruleLogicalAndOperator
	{ $current=$iv_ruleLogicalAndOperator.current.getText(); }
	EOF;

// Rule LogicalAndOperator
ruleLogicalAndOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='&&'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalAndOperatorAccess().getAmpersandAmpersandKeyword());
	}
;

// Entry rule entryRuleLogicalOrOperator
entryRuleLogicalOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalOrOperatorRule()); }
	iv_ruleLogicalOrOperator=ruleLogicalOrOperator
	{ $current=$iv_ruleLogicalOrOperator.current.getText(); }
	EOF;

// Rule LogicalOrOperator
ruleLogicalOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='||'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalOrOperatorAccess().getVerticalLineVerticalLineKeyword());
	}
;

// Entry rule entryRuleLogicalNotOperator
entryRuleLogicalNotOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalNotOperatorRule()); }
	iv_ruleLogicalNotOperator=ruleLogicalNotOperator
	{ $current=$iv_ruleLogicalNotOperator.current.getText(); }
	EOF;

// Rule LogicalNotOperator
ruleLogicalNotOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='!'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalNotOperatorAccess().getExclamationMarkKeyword());
	}
;

// Entry rule entryRuleBitwiseXOrOperator
entryRuleBitwiseXOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseXOrOperatorRule()); }
	iv_ruleBitwiseXOrOperator=ruleBitwiseXOrOperator
	{ $current=$iv_ruleBitwiseXOrOperator.current.getText(); }
	EOF;

// Rule BitwiseXOrOperator
ruleBitwiseXOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='^'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseXOrOperatorAccess().getCircumflexAccentKeyword());
	}
;

// Entry rule entryRuleBitwiseOrOperator
entryRuleBitwiseOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseOrOperatorRule()); }
	iv_ruleBitwiseOrOperator=ruleBitwiseOrOperator
	{ $current=$iv_ruleBitwiseOrOperator.current.getText(); }
	EOF;

// Rule BitwiseOrOperator
ruleBitwiseOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='|'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseOrOperatorAccess().getVerticalLineKeyword());
	}
;

// Entry rule entryRuleBitwiseAndOperator
entryRuleBitwiseAndOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseAndOperatorRule()); }
	iv_ruleBitwiseAndOperator=ruleBitwiseAndOperator
	{ $current=$iv_ruleBitwiseAndOperator.current.getText(); }
	EOF;

// Rule BitwiseAndOperator
ruleBitwiseAndOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='&'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseAndOperatorAccess().getAmpersandKeyword());
	}
;

// Rule PostFixOperator
rulePostFixOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='++'
			{
				$current = grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='--'
			{
				$current = grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule AssignmentOperator
ruleAssignmentOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='*='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='/='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='%='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='+='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='-='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5());
			}
		)
		    |
		(
			enumLiteral_6='<<='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_6, grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6());
			}
		)
		    |
		(
			enumLiteral_7='>>='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_7, grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7());
			}
		)
		    |
		(
			enumLiteral_8='&='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_8, grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8());
			}
		)
		    |
		(
			enumLiteral_9='^='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_9, grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9());
			}
		)
		    |
		(
			enumLiteral_10='|='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_10, grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10());
			}
		)
	)
;

// Rule ShiftOperator
ruleShiftOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='<<'
			{
				$current = grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='>>'
			{
				$current = grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule AdditiveOperator
ruleAdditiveOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='+'
			{
				$current = grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='-'
			{
				$current = grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule MultiplicativeOperator
ruleMultiplicativeOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='*'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='/'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='%'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule UnaryOperator
ruleUnaryOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='+'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='-'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='~'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule RelationalOperator
ruleRelationalOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='<'
			{
				$current = grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='<='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='>'
			{
				$current = grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='>='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='=='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='!='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5());
			}
		)
	)
;

RULE_LONG : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_BOOL : ('true'|'false'|'yes'|'no');

RULE_HEX : '0' ('x'|'X') ('0'..'9'|'a'..'f'|'A'..'F')+;

RULE_BINARY : '0' ('b'|'B') ('0'|'1')+;

RULE_DOUBLE : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('d'|'D')?;

RULE_FLOAT : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('f'|'F')?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

fragment RULE_INT : ('0'..'9')+;

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
