/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.validation

import com.yakindu.base.expressions.expressions.ReactionTrigger
import com.yakindu.base.types.Trigger
import com.yakindu.sct.model.sgraph.Choice
import com.yakindu.sct.model.sgraph.SGraphPackage
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.stext.stext.DefaultTrigger
import java.util.ArrayList
import java.util.Iterator
import java.util.List
import org.eclipse.xtext.validation.Check
import org.eclipse.xtext.validation.CheckType

class ChoiceValidator extends STextBaseValidator {

	public static final String ONLY_ONE_DEFAULT_SHOULD_BE_USED = "%s choice should have only one default or else transition.";

	@Check(CheckType.FAST)
	def void checkOnlyOneDefaultTransitionUsed(Choice choice) {
		var Iterator<Transition> iterator = choice.outgoingTransitions.iterator()
		var List<Transition> defaultTransitions = new ArrayList<Transition>()
		while (iterator.hasNext()) {
			var Transition transition = iterator.next()
			var Trigger trigger = transition.trigger
			if (trigger instanceof DefaultTrigger || trigger === null) {
				defaultTransitions.add(transition)
			}
		}
		var int size = defaultTransitions.size()
		if (size > 1) {
			var Iterator<Transition> iterator2 = defaultTransitions.iterator()
			while (iterator2.hasNext()) {
				warning(String.format(ONLY_ONE_DEFAULT_SHOULD_BE_USED, choice.name === null ? "A" : choice.name), iterator2.next(), null, -1)
			}
		}
	}

	public static final String CHOICE_ONE_OUTGOING_DEFAULT_TRANSITION = "%s choice should have one outgoing default transition.";

	@Check(CheckType.FAST)
	def void checkChoiceWithoutDefaultTransition(Choice choice) {
		var boolean found = false
		for (Transition transition : choice.outgoingTransitions) {
			var Trigger trigger = transition.trigger
			if (isDefault(trigger)) {
				found = true
			}
		}
		if(!found) warning(String.format(CHOICE_ONE_OUTGOING_DEFAULT_TRANSITION, choice.name === null ? "A" : choice.name) , SGraphPackage.Literals.VERTEX__OUTGOING_TRANSITIONS)
	}

	def protected boolean isDefault(Trigger trigger) {
		return trigger === null || trigger instanceof DefaultTrigger ||
			((trigger instanceof ReactionTrigger) && ((trigger as ReactionTrigger)).getTriggers().size() === 0 &&
				((trigger as ReactionTrigger)).guard === null)
	}

}
