/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.validation

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.Guard
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import org.eclipse.xtext.validation.Check
import org.eclipse.xtext.validation.CheckType
import com.yakindu.sct.model.sgraph.Transition

class GuardValidator extends STextBaseValidator {

	@Inject
	extension ITypeSystemInferrer typeInferrer

	@Check(CheckType.FAST)
	def void checkExpression(Guard expression) {
		typeInferrer.infer(expression, this)
	}

	public static final String GUARD_CONTAINS_ASSIGNMENT = "A guard must not contain assignments.";

	@Check(CheckType.FAST)
	def void checkNoAssignmentInGuard(Guard guard) {
		if (!guard.eAllContents.filter(AssignmentExpression).empty ||
			!guard.eAllContents.filter(PostFixUnaryExpression).empty) {
			error(GUARD_CONTAINS_ASSIGNMENT, guard, null)
		}
	}

}
