/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Andreas Muelder - itemis AG
*
*/
package com.yakindu.sctunit.generator.base

import com.google.inject.Inject
import com.google.inject.Injector
import com.yakindu.sct.generator.core.execution.AbstractGeneratorEntryExecutor
import com.yakindu.sct.generator.core.execution.NoLicenseFSAWrapper
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess
import com.yakindu.sct.license.LicenseChecker
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import com.yakindu.sctunit.sCTUnit.TestPackage

/**
 * @author oliver bohl - Initial contribution
 * @author Johannes Dicks - Refactoring based on EFS encapsulation
 * @authnor Axel Terfloth - remove n
 */
 
class SCTUnitGeneratorExecuter extends AbstractGeneratorEntryExecutor {
		
	@Inject protected Injector injector;	
	@Inject protected ISCTUnitGenerator generator
	
	// TODO: where to put?
//	override protected canHandle(GeneratorEntry entry) {
//		if (entry.elementRef instanceof TestGroup || entry.elementRef instanceof TestSuite)
//			return true
//		else
//			return false
//	}
	
	// TODO: define in each generator specific module
//	override Module getOverridesModule(GeneratorEntry entry) {
//		Modules.override(super.getOverridesModule(entry)).with(new Module() {
//			override def configure(Binder binder) {
//				binder.bind(GeneratorEntry).toInstance(entry);
//			}
//		})
//	}

	override execute(ISCTFileSystemAccess fsa, GeneratorEntry generatorEntry) {
		if (!isLicenseValid()) {
			generator.generate(generatorEntry, new NoLicenseFSAWrapper(fsa))
		} else {
			generator.generate(generatorEntry, fsa)
		}
	}
	
	def protected isLicenseValid() {
		return new LicenseChecker().checkStandardLicense().isValidOrTrial
	}
	
	override logStart(GeneratorEntry entry) {
		val element = entry.elementRef
		var elementName = ""
		var elementType = ""
		var targetProject = ""
		targetProject = getTargetProjectName(entry)
		if (element instanceof TestPackage) {
			elementName = (element as TestPackage).name
			elementType = TestPackage.simpleName
		}
		if (element instanceof SCTUnitClass){
			elementName = (element as SCTUnitClass).name
			elementType = SCTUnitClass.simpleName
		}
		if (element instanceof SCTUnitSuite) {
			elementName = (element as SCTUnitSuite).name
			elementType = SCTUnitSuite.simpleName
		}
		logger.log(String.format("Generating %s '%s' to target project '%s' ...", elementType, elementName, targetProject))
	}
	
	def getTargetProjectName (GeneratorEntry entry){
		return helper.getTargetProjectValue(entry).stringValue
	}	
	
	def getJavaPackageForProjectName(String targetProject){
		return targetProject.replaceAll("\\.", "/")	
	}
		
	def getTestModel(GeneratorEntry entry){
		return entry.elementRef.eContainer as TestPackage		
	}

	def getTargetFolderPath(GeneratorEntry entry){
		return helper.getTargetFolderValue(entry).stringValue
	}
	
}