/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
 
package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.BoolLiteral
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.FloatLiteral
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.LogicalNotExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Argument
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Package
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.generator.c.CExpressionsGenerator
import com.yakindu.sct.generator.c.types.CTypeAnnotations
import com.yakindu.sct.generator.c.typesystem.CTypeSystem
import com.yakindu.sct.generator.core.submodules.lifecycle.NamedConceptSequenceCode
import com.yakindu.sct.generator.cpp11.codepattern.DoxygenComment
import com.yakindu.sct.generator.cpp11.codepattern.MethodCode
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.concepts.StateMachineBehaviorConcept
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.base.types.EnumerationType
import com.itemis.create.base.generator.core.codemodel.Separator
import com.yakindu.base.types.TypeSpecifier

class CppExpressionsGenerator extends CExpressionsGenerator {

	@Inject protected extension CppNaming
	@Inject protected extension Literals
	@Inject protected extension MethodCode
	@Inject protected extension ExpressionExtensions
	@Inject protected extension EventRaisingCode
	@Inject protected extension FeatureCallSeparator
	@Inject protected extension StateMachineBehaviorConcept
	@Inject protected extension DoxygenComment
	@Inject protected extension NamedConceptSequenceCode
	@Inject protected extension CTypeAnnotations
	@Inject protected extension Separator


	/** TODO: reimplements the base implementation by override an override. Refactoring of CExpressionsGenertor is necessary.*/
	override dispatch code(TypeSpecifier it) 
		'''«targetLanguageName»«IF !type.isPointerType && !it.typeArguments.empty»<«FOR t : typeArguments SEPARATOR ', '»«t.code»«ENDFOR»>«ENDIF»'''

	override dispatch CharSequence code(ElementReferenceExpression it, Operation target) {
		if (target.isStateMachineConcept) 
			it.flow.stateMachineConceptCode(target)
		else
			'''«target.access»(«argumentsCode»)«arrayCode»'''
	} 
	
	override dispatch CharSequence code(ElementReferenceExpression it, OperationDefinition target) '''«target.access»(«argumentsCode»)'''
	
	override dispatch CharSequence code(ElementReferenceExpression it, Method target) '''«target.access»(«argumentsCode»)'''
	
	def dispatch CharSequence code(ElementReferenceExpression it, Event target) '''«target.access»'''
	
	def dispatch CharSequence code(Expression it, Type t) {
		if(t instanceof ComplexType)
			'''«t.name»_temp'''
		else '''«code»'''
	}
	
	def CharSequence initExpCode(InitializationExpression it, Argument context){		 
		val originalType = it.infer.type
		'''
		«originalType.namespacePath»«originalType.name» «originalType.name»_temp = «originalType.namespacePath»«originalType.name»();
		«FOR a : arguments»
		«val argType = (originalType as ComplexType).features.filter(TypedDeclaration).get(arguments.indexOf(a)).type»
		«IF (a.parameter !== null && (a.parameter.type instanceof ComplexType) && (!(a.parameter.type instanceof EnumerationType))) || (argType instanceof ComplexType && (!(argType instanceof EnumerationType)))»«(a.value as InitializationExpression).initExpCode(a)»«ENDIF»
		«originalType.name»_temp.«IF a?.parameter?.name !== null»«a.parameter.name» = «a.value.code(a.parameter.type)»;«ELSE»
		«(originalType as ComplexType).features.get(arguments.indexOf(a)).name» = «a.value.code((originalType as ComplexType).features.filter(TypedDeclaration).get(arguments.indexOf(a)).type)»;«ENDIF»
		«ENDFOR»
		'''
	}
	
	def dispatch Type getOriginalType(InitializationExpression it, EventRaisingExpression context){
		return getOriginalType(context.event.featureOrReference)
	}
	/** 
	def dispatch Type getOriginalType(InitializationExpression it, InitializationArgument context){
		if(context.property !== null) return context.property.type.infer.type
		else return getOriginalType(context.eContainer)
	}
	*/
	
	def dispatch Type getOriginalType(InitializationExpression it, InitializationExpression context){
		return getOriginalType(context.eContainer)
	}
	
	def dispatch Type getOriginalType(InitializationExpression it, TypedDeclaration context){
		return context.typeSpecifier.type.infer.type
	}
	
	def dispatch Type getOriginalType(InitializationExpression it, Argument context){
	}
	override dispatch CharSequence code(ElementReferenceExpression it, Property target) '''«target.access»«arrayCode»'''

	override dispatch CharSequence code(EventRaisingExpression it) {
			if(value instanceof InitializationExpression){
					val originType = (event.featureOrReference as EventDefinition).typeSpecifier.type
					'''
					«originType.namespacePath»«originType.name» temp = «originType.namespacePath»«originType.name»();
					«FOR a : (value as InitializationExpression).arguments»
					«val argType = (originType as ComplexType).features.filter(TypedDeclaration).get((value as InitializationExpression).arguments.indexOf(a)).type»
					«IF (a.parameter !== null && (a.parameter.type instanceof ComplexType) && a.value instanceof InitializationExpression) || (argType instanceof ComplexType && a.value instanceof InitializationExpression)
					»«(a.value as InitializationExpression).initExpCode(a)»«ENDIF»
					temp.«IF a?.parameter?.name !== null»«a.parameter.name» = «a.value.code(a.parameter.type)»;
					«ELSE»«(originType as ComplexType).features.get((value as InitializationExpression).arguments.indexOf(a)).name» = «a.value.code((originType as ComplexType).features.filter(TypedDeclaration).get((value as InitializationExpression).arguments.indexOf(a)).type)»;«ENDIF»
					«ENDFOR»
					«raiseEvent(it, "temp")»'''
			} else{
				'''«raiseEvent(it, value?.code)»'''
			}
		
	}  

	override dispatch CharSequence code(ActiveStateReferenceExpression it) '''«flow.stateActiveFctID»(«value.shortName»)'''
	
	override dispatch CharSequence code(EventValueReferenceExpression it) {
		val fc = value
		if (fc instanceof FeatureCall) {
			if (fc.feature.isExternal) {
				return '''«fc.context»«fc.feature.asGetter»()'''
			}
		}
		return '''«fc.featureOrReference.valueAccess»'''
	}
	
	override dispatch CharSequence code(AssignmentExpression it) {
		val varRef = varRef
		if(varRef instanceof FeatureCall){
			val container = varRef.feature.eContainer
			if (container instanceof ComplexType && (container.isMultiSM || container.isInternalStatemachineType)) {
				return '''«varRef.owner.code»«container.originCallSep»«varRef.feature.asSetter»(«expression.code»)'''
			}
		}
		return super._code(it)
	}
	
	/* Feature Call */
	override dispatch CharSequence code(FeatureCall it, Operation target) '''«context»«target.access»(«argumentsCode»)«arrayCode»'''
	
	override dispatch CharSequence code(FeatureCall it, OperationDefinition target) '''«context»«target.access»(«argumentsCode»)«arrayCode»'''
	
	override dispatch CharSequence code(FeatureCall it, EventDefinition target) '''«context»«target.access»'''
	
	override dispatch CharSequence code(FeatureCall it, VariableDefinition target) '''«context»«target.access»«arrayCode»'''
	
	override dispatch CharSequence code(FeatureCall it, Property target) {
		if (isExtensionProperty(target)) {
			if(CTypeSystem.POINTER_PROPERTY.exists[p | target.name == p]){
				return '''&(«it.owner.code»)'''
			}
		}

		if (isValueOnPointer) {
			return '''(*(«it.owner.code»))'''
		}
		propertyCode(target)
	}
	
	override protected propertyCode(FeatureCall it, Property target) {
		val owner = it.owner
		if (owner instanceof FeatureCall) {
			if (owner.isValueOnPointer) {
				return '''(«owner.code»).«target.access»«arrayCode»'''
			}
		}
		'''«context»«target.access»«arrayCode»'''
	}
	
	override dispatch CharSequence code(FeatureCall it, Enumerator target) {
		if(target.eContainer.isOriginStatechart) {
			return target.stateEnumerator
		}
		return '''«target.type.namespacePath»«target.access»'''
	}
	
	def stateEnumerator(Enumerator it) {
		stateEnumAccess
	}
	
	override dispatch CharSequence rawEventAccess(ElementReferenceExpression it, Event owner)
		'''«owner.scope.namedInstanceAccess»«owner.name.asEscapedIdentifier»'''
	
	protected def dispatch context(FeatureCall it) {
		val ownerCode = owner.code.toString
		if (ownerCode.isEmpty) {
			ownerCode 
		}
		else {
			val separator = it.definesSeparator ? it.separator : owner.callSep
			ownerCode + separator
		}
	}
	
	protected def dispatch context(ElementReferenceExpression it) {
		val refCode = code.toString
		if (refCode.isEmpty) refCode else refCode + callSep
	}
	
	protected def dispatch context(Expression it) ''''''

	/* Literals */
	override dispatch CharSequence code(BoolLiteral it) '''«IF value»true«ELSE»false«ENDIF»'''
	
	/** Don't use bool_true for C++ code */
	override dispatch CharSequence sc_boolean_code(Expression it) {code}
	
	/** Don't use bool_false for C++ code */
	override dispatch CharSequence sc_boolean_code(LogicalNotExpression it) {code}
	
	protected def argumentsCode(ArgumentExpression it) '''«FOR arg : expressions SEPARATOR ', '»«arg.code»«ENDFOR»'''
	
	def dispatch CharSequence code(Operation it) {
		if (it.isStateMachineConcept) 
			it.flow.stateMachineConceptCode(it)
		else
			methodDefinitionCode
	}
	
	def calculateInitialValue(Property it){''''''}
		
	override dispatch CharSequence code(PrimitiveValueExpression it){
		'''«value.code»'''
	}
	
	def dispatch CharSequence code(ElementReferenceExpression it, Package namespace) '''«namespace.name»'''
	
	def dispatch CharSequence code(ElementReferenceExpression it, ComplexType target) '''«target.name»'''
	
	def dispatch CharSequence code(FeatureCall it, ComplexType target) 	'''«owner.code»«IF target.isCStruct».«ELSE»::«ENDIF»«target.name»'''
	
	def dispatch CharSequence code(FeatureCall it, EnumerationType target) 	'''«owner.code»::«it.code(it.feature)»'''
	
	def dispatch CharSequence code(FeatureCall it, Package namespace) '''«IF !owner.featureOrReference.isTopLevelPackage»«owner.code(owner.featureOrReference)»::«ENDIF»«namespace.name»'''
	
	override dispatch code(FloatLiteral it) {
		value + 'f'
	}
	
	override invokeSetter(AssignmentExpression it, Declaration origin, CharSequence vHandle) {
		return '''«origin.scope.namedInstanceAccess»«origin.asSetter»(«assignCmdArgument(it, vHandle)»)'''
	}
	
	override invokeAssignment(AssignmentExpression it, Declaration origin, CharSequence vHandle) {
		return '''«origin.scope.namedInstanceAccess»«origin.assign»(«assignCmdArgument(it, vHandle)»)'''
	}
	
	override varHandle(Expression vRef) {
		val vHandle = (vRef instanceof FeatureCall ? vRef.owner.code : "this")
		return (vHandle.toString.empty ? '''this«ifaceAcces»''' : vHandle)
	}
}
