package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*
import com.yakindu.base.types.ComplexType

class CppFileNaming extends FileNaming{
	
	@Inject GeneratorEntry entry
	@Inject protected extension CppTypes
	
	override module(ExecutionFlow it) {
		super.module(it).toFirstUpper
	}
	
	override module(Statechart it) {
		super.module(it).toFirstUpper
	}
	
	def module(ComplexType it) {
		it.name.asIdentifier.toFirstUpper
	}
	
	override rxcModule() {
		RXCPP_MODULE
	}
	
	override statemachineModule() {
		CPP_STATEMACHINE_MODULE
	}
	
	def cycleBasedModule() {
		CYCLEBASED_MODULE
	}
	
	def eventDrivenModule() {
		EVENTDRIVEN_MODULE
	}
	
	def subMachineModule() {
		SUBMACHINE_MODULE
	}
	
	def subMachineContextModule() {
		SUBMACHINE_CONTEXT_MODULE
	}
	
	def timerModule() {
		TIMER_MODULE
	}
	
	def String cpp(String it) '''«it».«entry.sourceFilenameExtension»'''
	
}