/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.templates.ClassDeclaration
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.StatechartScope

/**
 * @author Robin Herrmann
 */
class CppObservables {
	
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppSpecifiers
	@Inject protected extension EventQueue

	def createObserverClass(Event shadowEvent, ClassDeclaration observerDecl, StatechartScope scope) {
		observerDecl.name(shadowEvent.observerClass)
		observerDecl.superType('''public «scRxNS»::SingleSubscriptionObserver<«shadowEvent.typeSpecifier.targetLanguageName»>''')
		observerDecl.member(ClassDeclaration::PUBLIC, shadowEvent.createObserverConstructor(scope))
		observerDecl.member(ClassDeclaration::PUBLIC, shadowEvent.createObserverNextImpl )
		observerDecl.member(ClassDeclaration::PUBLIC, scope.createInterfaceMember)
		return observerDecl
	}
	
	def CharSequence createObserver(Event it){
		'''
		«observerClass» «observer» «observerClass.multiStmInclassInit»;
		'''
	}
	
	def CharSequence createObserverConstructor(Event it, StatechartScope scope){
		'''
			«_explicit»«observerClass»(«scope.interfaceNameByScope»* i)«_noexcept» :
				SingleSubscriptionObserver(),
				«interfaceMember»(i)
			{}
		'''
	}
	
	def createInterfaceMember(StatechartScope scope) {
		'''«scope.interfaceNameByScope»* «interfaceMember»;'''
	}
	
	def getInterfaceNameByScope(StatechartScope it) {
		switch it {
			InterfaceScope case name !== null: '''«interfaceName»'''
			InterfaceScope case name === null: '''«flow.module»'''
			InternalScope: '''«flow.module»'''
		}
	}
	
	def CharSequence createObserverNextImpl(Event it) {
		'''
		virtual void next(«IF ITypeSystem.VOID !== typeSpecifier.targetLanguageName»«typeSpecifier.targetLanguageName» value«ENDIF»)«eventFuncThrowsException»«_override» {
			this->«interfaceMember»->«event.asRaiser»(«IF hasValue»value«ENDIF»);
		}
		'''
	}
	
}