/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp.eventdriven

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.sct.generator.cpp.EventRaisingCode
import com.yakindu.sct.generator.cpp.submodules.eventdriven.EventDrivenEventCode
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.stext.stext.EventDefinition
import java.util.ArrayList
import java.util.List

class EventDrivenEventRaisingCode extends EventRaisingCode {
	@Inject protected extension EventNaming
	@Inject protected extension EventQueue
	@Inject protected extension EventDrivenEventCode

		
	override protected raiseLocalEvent(EventRaisingExpression it, CharSequence valueCode) {
		'''«internalQueue».push_back(«eventObjectPointer(valueCode)»)'''
	}
	
	override protected List<CharSequence> raiseDefaultEventStatements(EventRaisingExpression it, CharSequence valueCode) {
		if(flow.requiresIncomingEventQueue){
			val statements = new ArrayList<CharSequence>()
		
			statements += queueEventCode(it.event.definition as EventDefinition)
		
			return statements
		} else 
			super.raiseDefaultEventStatements(it, valueCode)				
	}
	
	def protected eventObjectPointer(EventRaisingExpression it, CharSequence valueCode) {
		val cls = event.definition.event.eventClassName
		val enm = event.definition.event.eventEnumMemberName
		val args = '''«enm»«IF value !== null», «valueCode»«ENDIF»'''
		'''new «cls»(«args»)'''
	}
	
}