/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * 	Laszlo Kovacs - itemis AG
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

class MetaSource implements IContentTemplate<ExecutionFlow> {
	@Inject extension GenmodelEntriesExtension
	@Inject extension CppNaming
	@Inject extension CppFileNaming
	@Inject extension SExecExtensions
	@Inject extension CppTypes
	
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#include "«(flow.metaModule.h).relativeTo(flow.metaModule.cpp)»"
		
		namespace «flow.module.define»Meta {
				
		const «sc_string.name» «flow.metaFeaturesProperty»[«flow.metaFeaturesProperty»Size] = {
			"<nothing>",
			«FOR feature : flow.scopes.map[it | it.eventAndVariableDefinitions].flatten SEPARATOR ","»
			"«feature.metaName»"
			«ENDFOR»
		};
		
		const «sc_string.name» «flow.metaStatesProperty»[«flow.metaStatesProperty»Size] = {
			"NO_STATE",
			«FOR state : flow.states SEPARATOR ","»
			"«state.name.removePrefix»"
			«ENDFOR»
		};
		
		} // namespace «flow.module.define»Meta
		'''
	}
	
	def protected removePrefix(String s){
		return s.substring(s.indexOf(".")+1)
	}
		
}