/**
 * Copyright (c) 2020-2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author axel terfloth
 */
class StatemachineInterface implements IContentTemplate<ExecutionFlow> {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension CppTypes
	
	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#ifndef «statemachineModule.define»_H_
		#define «statemachineModule.define»_H_
		
		namespace sc {
		
		/*! \file 
		Basic interface for state machines.
		*/
		class «statemachineInterface»
		{
			public:
			
				virtual ~«statemachineInterface»() = 0;
				
				/*!
				Enters the state machine. Sets the state machine into a defined state.
				*/
				virtual void «enterFctID»() = 0;
			
				/*!
				Exits the state machine. Leaves the state machine with a defined state.
				*/
				virtual void «exitFctID»() = 0;
				
				/*!
				Checks whether the state machine is active. 
			 	A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
			 	*/	
				virtual	«sc_bool.fqName» «isActiveFctID»() const = 0;
				
				/*!
				Checks if all active states are final. 
			 	If there are no active states then the state machine is considered being inactive. In this case this method returns false.
			 	*/
				virtual «sc_bool.fqName» «isFinalFctID»() const = 0;
		};
		
		inline «statemachineInterface»::~«statemachineInterface»() {}
		
		} /* namespace sc */
		
		#endif /* «statemachineModule.define»_H_ */
		'''
	}
	
}