/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * 
 * @author laszlo kovacs - Initial contribution
 */
class SubMachineInterface implements IContentTemplate<ExecutionFlow> {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension CppPointers
	@Inject protected GeneratorEntry entry
	
	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#ifndef «subMachineModule.define»_H_
		#define «subMachineModule.define»_H_
		
		#include "«statemachineModule.h»"
		#include "«subMachineContextModule.h»"
		«memoryInclude»
		
		namespace sc {
		
		/*! \file
		Interface for submachines.
		*/
		class «submachineInterface» : public sc::«statemachineInterface»
		{
			public:
			
				virtual ~«submachineInterface»() = 0;
			
				/*! Start a processing cycle for the submachine.
				*/
				virtual bool «runSubmachineCycleID»() = 0;
				
				/*! Interface for the parent to call to initiate the process of the next event of the child.
				*/
				virtual void «enableNextEventID»() = 0;
								
				/*! Sets the parential context for the submachine.
				*/
				virtual void «setSubmachineContextID»(const «sharedPtr»«submachineContextInterface»«pointerType» ctx) = 0;
		};
		
		inline «submachineInterface»::~«submachineInterface»() {}
		
		} /* namespace sc */
		
		#endif /* «subMachineModule.define»_H_ */
		'''
	}
	
}