/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class Tracing implements IContentTemplate<ExecutionFlow> {

	@Inject extension GenmodelEntries
	@Inject extension CppFileNaming
	@Inject extension CppNaming

	override content(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) '''
		«entry.licenseText»
		
		#ifndef «tracingModule.define»_H_
		#define «tracingModule.define»_H_
		
		namespace sc {
		namespace trace {
		
		template<typename T>
		class «traceObserver»
		{
		public:
			virtual ~«traceObserver»(){}
		
			virtual void stateEntered(T state) = 0;
		
			virtual void stateExited(T state) = 0;
		};
		} /* namespace sc::trace */
		} /* namespace sc */
		
		#endif /* «tracingModule.define» */
		
	'''

}
