/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers.eventdriven

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.eventdriven.EventNaming
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.EventDefinition

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*
import com.yakindu.sct.model.sexec.naming.INamingService

/**
 * @author René Beckmann - Initial contribution and API
 */
class StatechartEvents implements ISourceFragment {

	@Inject protected extension EventQueue
	
	@Inject protected extension CppNaming
	@Inject protected extension INamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension GeneratorPredicate
	
	@Inject extension EventNaming eventNaming
	
	@Inject protected GeneratorEntry entry
	protected ExecutionFlow flow
	
	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		content
	}
	
	def content(ExecutionFlow it) {
		if(!needsEventClasses) return ''''''
		'''
			#ifndef «generateHeaderDefineGuard»
			#define «generateHeaderDefineGuard»
			#ifndef «invalidEvent»
			#define «invalidEvent» 0
			#endif
			
			namespace «eventNamespaceName»
			{
			«generateEventsEnum»
			
			«generateEventBaseClasses»
			
			«generateEvents»
			
			}
			#endif /* «generateHeaderDefineGuard» */
		'''
	}
	
	def generateEventsEnum(ExecutionFlow it) {
		'''
			typedef enum  {
				«invalidEventEnumName(it)» = «invalidEvent»,
				«FOR e : allEvents.filter[isQueued].toList SEPARATOR ","»
					«e.eventEnumMemberName»
				«ENDFOR»
			} «eventEnumName»;
		'''
	}
	
	def generateHeaderDefineGuard(ExecutionFlow it) {
		'''SCT_EVENTS_«name.asIdentifier.toUpperCase»_H'''
	}
	
	def generateEventBaseClasses(ExecutionFlow it) {
		'''
			class «SCT_EVENT»
			{
				public:
					«SCT_EVENT»(«eventEnumName» name_) : name(name_){}
					virtual ~«SCT_EVENT»(){}
					const «eventEnumName» name;
					
			};
					
			template <typename T>
			class «TYPED_SCT_EVENT» : public «SCT_EVENT»
			{
				public:
					«TYPED_SCT_EVENT»(«eventEnumName» name_, T value_) :
						«SCT_EVENT»(name_),
						value(value_)
						{}
					virtual ~«TYPED_SCT_EVENT»(){}
					const T value;
			};
		'''
	}
	
	def generateEvents(ExecutionFlow it) {
		'''
			«FOR s : scopes»
				«FOR e : s.declarations.filter(EventDefinition).filter[isQueued]»
					«generateEventClass(e, it)»
				«ENDFOR»
			«ENDFOR»
			«IF isTimed»
				«generateTimedEventClass»
			«ENDIF»
		'''
	}
	
	def generateEventClass(Event it, ExecutionFlow flow) {
		'''
			«IF hasValue»
				«generateTypedEventClass(flow)»
			«ELSE»
				«generateNormalEventClass(flow)»
			«ENDIF»
		'''
	}
	
	def generateTimedEventClass(ExecutionFlow it) {
		'''
			class «timedEventClassName» : public «SCT_EVENT»
			{
				public:
					«timedEventClassName»(«eventEnumName» name_) : «SCT_EVENT»(name_){};
			};
		'''
	}
	
	def generateTypedEventClass(Event it, ExecutionFlow flow) {
		val type = typeSpecifier.targetLanguageName
		'''
			class «eventClassName» : public «TYPED_SCT_EVENT»<«type»>
			{
				public:
					«eventClassName»(«flow.eventEnumName» name_, «type» value_) :
						«TYPED_SCT_EVENT»(name_, value_) {};
			};
		'''
	}
	
	def generateNormalEventClass(Event it, ExecutionFlow flow) {
		'''
			class «eventClassName» : public «SCT_EVENT»
			{
				public:
					«eventClassName»(«flow.eventEnumName» name_) : «SCT_EVENT»(name_){};
			};
		'''
	}
	
	def getBaseClass(EventDefinition it) {
		'''
			«IF hasValue»
				«TYPED_SCT_EVENT»
			«ELSE»
				«SCT_EVENT»
			«ENDIF»
		'''
	}
}
