/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.extensions.CodeModelGeneratorExtension
import com.yakindu.sct.generator.cpp.CppGenerator
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.google.inject.Provider
import com.yakindu.sct.generator.cpp11.artifacts.CppFile
import com.yakindu.sct.generator.cpp11.artifacts.HeaderFile
import com.yakindu.base.types.Package
import com.itemis.create.base.generator.core.artifacts.SourceFile
import com.yakindu.sct.model.sexec.concepts.PropertyBinder
import com.google.inject.Injector
import com.yakindu.sct.generator.cpp11.files.SCBinding

/**
 * Generator for C++11. It relies on the code model for code generation. 
 * 
 * @author axel terfloth
 */
class Cpp11Generator extends CppGenerator {
	
	@Inject protected Injector injector
	@Inject protected extension CodeModelGeneratorExtension
	@Inject protected Provider<CppFile> cppFileProvider
	@Inject protected Provider<HeaderFile> headerFileProvider
	@Inject protected extension PropertyBinder
	
	
	override initLibraryArtifacts(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		super.initLibraryArtifacts(flow, entry, locations)
		
		if (flow.appliesBinder) {
			configureSourceFile(injector.getInstance(SCBinding), entry.libraryOutput)
		}
	}
	
	override initStatechartArtifacts(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		
		flow.provideFlows(entry).forEach[ f |
			transformFlow(f, entry)
			super.initStatechartArtifacts(f, entry, locations)
		]
	}
	
	/** Subclasses can provide a list of execution flows e.g. for connected statechart types. */
	def protected transformFlow(ExecutionFlow flow, GeneratorEntry entry) {
		flow.defineClass(entry)
	}
	
	def provideFlows(ExecutionFlow flow, GeneratorEntry entry) {
		#[flow]
	}
	
	def void configureCppFile(Package compilationUnit, String path) {
		cppFileProvider.get => [ file |
			file.compilationUnit = compilationUnit
			locations.configure(file.fileName, path, file)
		]
	}
	
	def void configureHeaderFile(Package compilationUnit, String path) {
		headerFileProvider.get => [ file |
			file.compilationUnit = compilationUnit
			locations.configure(file.fileName, path, file)
		]
	}
	
	def void configureSourceFile(SourceFile file, String path) {
		locations.configure(file.fileName, path, file)
	}
	
}