/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.generator.cpp11.codemodel.CodeModel
import com.yakindu.sct.generator.cpp11.codepattern.VariableCode
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.generator.cpp11.codepattern.MethodCode

/**
 * @author axel terfloth
 */
class Cpp11MethodImplementationProvider implements ISourceFragment {
	
	@Inject protected extension SExecExtensions
	@Inject protected extension CodeModel
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension GeneratorAssignment
	@Inject protected extension VariableCode
	@Inject protected extension MethodCode
	
	

	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) '''
		«FOR e : #[implementationClass.features, it.features].flatten.filter(Operation).filter[definitionGenerator !== null]»
			
			«e.definitionCode»
			
		«ENDFOR»
		«««	also generate meta features for exiatig variable definitions
		«FOR e : allVariableDefinitions.map[metaFeatures].flatten»
			
			«e.code»
			
		«ENDFOR»
	'''	
	
	def protected dispatch code(Operation it) {
		methodDefinitionCode
	}
	
	def protected dispatch code(Declaration it) ''''''
	
}
