/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.yakindu.sct.generator.cpp.CppPointers

/**
 * Pointer related methods 
 * 
 * @author laszlo kovacs- Initial contribution.
 */
class Cpp11Pointers extends CppPointers{
	
	override shareThis()'''shared_from_this()'''
	
	override String enableShared(CharSequence type)'''public std::enable_shared_from_this<«type»>'''
	
	override String move(CharSequence type)'''std::move(«type»)'''
	
	override deletePointer(){}
	
	override freePointer()'''.reset()'''
	
	override makeTypeCloser(){pointerType}
	
	override pointerType() '''>'''
	
	override sharedPtr() '''std::shared_ptr<'''
	
	override makeSharedPtr() '''std::make_shared<'''

	override uniquePtr() '''std::unique_ptr<'''
		
	override weakPtr() '''std::weak_ptr<'''
	
	override CharSequence memoryInclude() '''#include <memory>'''
	
	override CharSequence stdMove(CharSequence uniquePtr)'''std::move(«uniquePtr»)'''

	override lockIfNecessary()'''.lock()'''

}