/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.model.stext.stext.VariableDefinition

class Cpp11Specifiers extends CppSpecifiers{
	
	@Inject protected extension ITypeSystem
	
	public static String NO_EXCEPTION = "__noexcept__"
	
	override _override() ''' override'''
	
	override _explicit() '''explicit '''
	
	override _noexcept() ''' noexcept'''
	
	override _virtual()	''''''
	
	override _const() ''' const'''
	
	override _constexpr(){
		'''constexpr'''
	}
	
	override multiStmInclassInit(CharSequence clazz) '''{this}'''
	
	override requiresObservable(){
		false
	}
	
	override requiresInitialization(VariableDefinition it){
		if(type.isString) true
		else false
	}
	
	override requiresInitializationList(){
		false
	}
	
	override dispatch assignValue(CharSequence it) '''{«it»}'''
	override dispatch assignValue(int it) '''{«it»}'''
}