/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.generator.cpp11.codepattern.MethodCode
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.concepts.SubMachine
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.EventDefinition

import static com.yakindu.sct.generator.core.extensions.EventQueueExtension.*
import com.yakindu.sct.model.sexec.concepts.SubMachine.SubmachineTypeLibrary

/**
 * This extension defines event queues. 
 * 
 * @author axel terfloth - Initial contribution.
 */
class EventQueueImplementation {

	
	public static final String CAST_EVENT_POINTER_TYPE= "cast_event_pointer_type"
	

	@Inject protected extension EventQueue
	
	@Inject protected extension TypeBuilder
	@Inject protected extension SExecExtensions
	@Inject protected extension CppNaming
	@Inject protected extension CppTypes
	@Inject protected extension CppSpecifiers

	@Inject protected extension EventEnum
	@Inject protected extension EventInstanceClasses
	@Inject protected extension StatemachineClass
	@Inject protected extension EventQueueExtension
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension Documentation

	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension GeneratorAssignment
	@Inject protected extension MethodCode
	@Inject protected extension Literals
	@Inject protected extension CppPointers
	@Inject protected extension SubMachine
	@Inject protected extension SubmachineTypeLibrary
	
	@Inject protected GeneratorEntry entry
	@Inject protected extension GenmodelEntriesExtension
	
	
	def void defineEventQueueImplementation(ExecutionFlow flow) {
		
		if (flow.requiresIncomingEventQueue) {
			
			_variable(INCOMING_EVENT_QUEUE_NAME, _any) => [
				_protected
				flow.stateMachineClass.features += it;
				generateDeclarationWith[it.eventQueueDeclaration(flow.eventInstanceClass)]			
			]
		}
		
		if (flow.requiresInternalEventQueue) {
			
			_variable(INTERNAL_EVENT_QUEUE_NAME, _any) => [
				_protected
				flow.stateMachineClass.features += it;
				generateDeclarationWith[it.eventQueueDeclaration(flow.eventInstanceClass)]			
			]
		}
		
		
		if (flow.requiresEventQueue) {

			_op(GET_NEXT_EVENT_METHOD_NAME, _void) => [
				_protected
				flow.stateMachineClass.features += it;
				
				generateDeclarationWith['''
					«uniquePtr»«flow.eventInstanceClass.name»«pointerType» «name»()«_noexcept»;
				''']
				
				generateDefinitionWith[
					val nE = "nextEvent"
					val smClassName = flow.stateMachineClass.name
					val internalEventQueue = flow.internalEventQueue
					val incomingEventQueue = flow.incomingEventQueue
										
					'''
						«uniquePtr»«flow.eventInstanceClass.asLiteral»«pointerType» «smClassName»::«name»()«_noexcept»
						{
							«uniquePtr»«flow.eventInstanceClass.asLiteral»«pointerType» «nE» = nullptr;

							«IF internalEventQueue.exists»
								if(!«internalEventQueue.name».empty()) {
									«nE» = «internalEventQueue.name.front.move»;
									«internalEventQueue.name».pop_front();
								}
							«ENDIF»
							«IF incomingEventQueue.exists»
								«IF internalEventQueue.exists»else «ENDIF»if(!«incomingEventQueue.name».empty()) {
									«nE» = «incomingEventQueue.name.front.move»;
									«incomingEventQueue.name».pop_front();
								}
							«ENDIF»
							
							return «nE»;
							
						}					
					''']				
			]


			_op(DISPATCH_EVENT_METHOD_NAME, _void) => [
				_protected
				flow.stateMachineClass.features += it;
				
				generateDeclarationWith['''
					«sc_bool.fqName» «name»(«uniquePtr»«flow.eventInstanceClass.name»«pointerType» event)«flow.propertyThrowsException»;
				''']
				
				generateDefinitionWith[
					val ev = "event"
					val smClassName = flow.stateMachineClass.name
					val smcEvents = flow.eventsHandledByStatemachineClass
					
					'''
						«IF !entry.usePlainPointers && (flow.requiresIncomingEventQueue || flow.allEvents.exists[hasValue])»
						template<typename EWV, typename EV>
						std::unique_ptr<EWV> cast_event_pointer_type (std::unique_ptr<EV>&& event){
						    return std::unique_ptr<EWV>{static_cast<EWV*>(event.release())};
						}
						«ENDIF»
							
						«sc_bool.fqName» «smClassName»::«name»(«uniquePtr»«flow.eventInstanceClass.asLiteral»«pointerType» «ev»)«flow.propertyThrowsException»
						{
							if(«ev» == nullptr) {
								return false;
							}
														
							switch(«ev»->eventId)
							{
								«FOR e : smcEvents»
									case «e.enumerator.asLiteral»:
									{
										«IF e.hasValue»
											«uniquePtr»«e.eventClassName»«pointerType» e = «cast_function»<«e.eventClassName» «IF entry.usePlainPointers»*«ENDIF»>(«ev.move»);

											if(e != nullptr) {
												«e.activateEventCode("e->value")»
											}
										«ELSE»
											«e.activateEventCode(null)»
										«ENDIF»
										break;
									}
								«ENDFOR»
								
								«FOR s : flow.namedInterfaceScopes»
									«val events = s.queuedEvents.filter(EventDefinition)»
									«IF events.size > 0»
										«FOR e : events»
										case «e.enumerator.asLiteral»:
										{
											«IF e.hasValue»
												«uniquePtr»«e.eventClassName»«pointerType» e = «cast_function»<«e.eventClassName» «IF entry.usePlainPointers»*«ENDIF»>(«ev.move»);
												if(e != nullptr) {
													«e.activateEventCode("e->value")»
												}
											«ELSE»
												«e.activateEventCode(null)»
											«ENDIF»
											break;
										}
										«ENDFOR»
									«ENDIF»
								«ENDFOR»
								«FOR subM : flow.eAllContents.filter(Property).filter[type.appliesSubMachine].toList»
									case «subM.enumerator.asLiteral»:
									{ 
										«subM.scope.namedInstanceAccess»«subM.name»->«getSubmachineInterfaceEnableNextEvent.name»();
										break;
									}
								«ENDFOR»
								«IF flow.requiresIncomingEventQueue»
									«val events = flow.timeEvents»
									«IF events.size > 0»
									«FOR te : events»
										case «te.enumerator.asLiteral»:
									«ENDFOR»
									{
										«flow.timeEventScope.instance»[static_cast<«sc_integer.fqName»>(«ev»->eventId) - static_cast<«sc_integer.fqName»>(«flow.timeEvents.head.enumerator.asLiteral»)] = true;
										break;
									}
									«ENDIF»
								«ENDIF»
								default:
									//pointer got out of scope
									«IF entry.usePlainPointers»delete «ev»;«ENDIF»
									return false;
							}
							//pointer got out of scope
							«IF entry.usePlainPointers»delete «ev»;«ENDIF»
							return true;
						}
					'''
				]
			]
									
			
		}
	}
	
	def deleteEventQueues(ExecutionFlow it) {
		val nE = "nextEvent"
		'''
		«IF entry.usePlainPointers && internalEventQueue.exists»
		while (!«internalEventQueue.name».empty()) {
			auto «nE»{«internalEventQueue.name».front()};
			«internalEventQueue.name».pop_front();
			«deletePointer» «nE»«freePointer»;
		}
		«ENDIF»
		«IF entry.usePlainPointers && incomingEventQueue.exists»
		while (!«incomingEventQueue.name».empty()) {
			auto «nE»{«incomingEventQueue.name».front()};
			«incomingEventQueue.name».pop_front();
			«deletePointer» «nE»«freePointer»;
		}
		«ENDIF»
		'''
	}
	
	def cast_function(){
		if(entry.usePlainPointers) '''static_cast'''
		else CAST_EVENT_POINTER_TYPE
	}
	
	def CharSequence front(CharSequence s) '''«s».front()'''
	
	def activateNextEventCode(ExecutionFlow it) {
		if ( dispatchEventMethod.exists && nextEventMethod.exists) '''
			«dispatchEventMethod.name»(«nextEventMethod.name»());
		'''
		else ''''''
	}
	
	def protected activateEventCode(EventDefinition e, String value) '''
		«IF e.hasValue»
			«e.scope.namedInstanceAccess»«e.localValueAccess» = «value»;
		«ENDIF»
		«e.scope.namedInstanceAccess»«e.localAccess» = true;
	'''
	
	
	protected def eventQueueDeclaration(Property it, Type elementType) '''
		std::deque<«uniquePtr»«elementType.name»«pointerType»> «name»;
	'''
	
	protected def eventClassName(EventDefinition it) {
		if ( it.hasValue )
			'''«flow.eventInstanceWithValueClass.asLiteral»<«it.typeSpecifier.targetLanguageName»>'''
		else
			'''«flow.eventInstanceClass.asLiteral»'''
	}
	
}