/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.concepts.SubMachine
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.core.extensions.EventQueueExtension.*

class SubmachineContextClass {
	
	public static final String EVENT_INSTANCE_CLASS_NAME = "EventInstance"
	public static final String EVENT_INSTANCE_WITH_VALUE_CLASS_NAME = "EventInstanceWithValue"

	@Inject protected extension EventQueue
	
	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension StatemachineClass
	@Inject protected extension SubMachine
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension EventInstanceClasses
	@Inject protected extension Literals
	@Inject protected extension CppNaming
	@Inject protected extension CppPointers
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected GeneratorEntry entry
	
	def void defineSubmachineContextClass(ExecutionFlow flow) {
		
		flow.submachineContextType => [
			flow.stateMachineClass.features += it;
			generateDeclarationWith['''
				class «name» : public «superTypes.head.asLiteral»
				{
					public:
						«name»(std::function<void()> onEventRaised_)
							: onEventRaised(onEventRaised_) {}
					
						void «eventRaised.name»() const override {
							if (onEventRaised) {
								onEventRaised();
							}
						}
				
					private:
						std::function<void()> onEventRaised;
				};
			''']
		]	
	}
	
	def protected newEvent(ExecutionFlow flow){
		if(!entry.usePlainPointers)
			'''«uniquePtr»«flow.eventInstanceClass.asLiteral»«pointerType»(new «flow.eventInstanceClass.asLiteral»(mappedEvent))'''
		else
			'''new «flow.eventInstanceClass.asLiteral»(mappedEvent)'''
	}
		
	def submachineContextClass(ExecutionFlow flow) {
		flow.stateMachineClass.features.filter(ComplexType).filter[ c | c === flow.submachineContextType ].head
	}
}