/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.concepts

import com.yakindu.sct.model.sexec.concepts.SexecOutProperty
import com.yakindu.base.types.Property
import com.google.inject.Inject
import com.yakindu.sct.generator.cpp.concepts.CppReference
import com.google.inject.Singleton

/**
 * Defines a C++11 specific extension of the OutProperty concept. 
 * It defines the observable getter return value as a reference.
 * 
 * @author axel terfloth
 */
@Singleton
class Cpp11OutProperty extends SexecOutProperty {
	
	@Inject protected extension CppReference
	
	override protected defineOutPropertyObservableGetter(Property p) {
		super.defineOutPropertyObservableGetter(p)
		
		p.outPropertyObservableGetter => [
			val predefined = typeSpecifier
			typeSpecifier = cppReferenceType._typeSpecifier(predefined)
		]
	}
	
}