/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * 	Laszlo Kovacs - itemis AG
 */
package com.yakindu.sct.generator.cpp11.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.files.MetaSource
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

class Cpp11MetaSource extends MetaSource {
	@Inject extension GenmodelEntriesExtension
	@Inject extension CppNaming
	@Inject extension CppFileNaming
	@Inject extension SExecExtensions
	@Inject extension CppTypes
	
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#include "«(flow.metaModule.h).relativeTo(flow.metaModule.cpp)»"
		
		namespace «flow.module.define»Meta {
				
		const std::array<std::«sc_string.name», «flow.metaFeaturesProperty»Size> «flow.metaFeaturesProperty» = {
			"<nothing>",
			«FOR feature : flow.scopes.map[it | it.eventAndVariableDefinitions].flatten SEPARATOR ","»
			"«feature.metaName»"
			«ENDFOR»
		};
		
		const std::array<std::«sc_string.name», «flow.metaStatesProperty»Size> «flow.metaStatesProperty» = {
			"NO_STATE",
			«FOR state : flow.states SEPARATOR ","»
			"«state.name.removePrefix»"
			«ENDFOR»
		};
		
		} // namespace «flow.module.define»Meta
		'''
	}
		
}