/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.files

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.files.RxCppHeader

/**
 * @author lkovacs
 */
class Cpp11RxCppHeaderDynamicAlloc extends RxCppHeader{
	
	@Inject protected extension CppPointers
	@Inject protected extension CppSpecifiers
	@Inject protected extension Literals
	
	override includes(extension IGenArtifactConfigurations locations){
		super.includes(locations) +
		'''
		«memoryInclude»
		#include <vector>
		#include <algorithm>
		#include <functional>
		'''
	}
	
	override protected singleSubscriptionObserver()'''
	template<class T>
	class SingleSubscriptionObserver: public Observer<T> {
	public:
		SingleSubscriptionObserver()«_noexcept» {
		}
	
		bool subscribe(sc::rx::Observable<T> &o)«_noexcept» {
			return o.subscribe(subscription);
		}
	
		bool unsubscribe(sc::rx::Observable<T> &o)«_noexcept» {
			return o.unsubscribe(subscription);
		}
	
		void setSubscription(sc::rx::subscription<T> &s)«_noexcept» {
				subscription = s;
		}
		
		virtual ~SingleSubscriptionObserver() = default;
	
	protected:
		sc::rx::subscription<T> subscription {*this};
	};
	
	template<class T>
	class SimpleObserver: public SingleSubscriptionObserver<T> {
	public:
		explicit SimpleObserver(std::function<void(T)> callback) noexcept
			: SingleSubscriptionObserver<T>(), callback(callback) {
		}
		
		virtual void next(T value) override {
			if (callback) {
				callback(value);
			}
		}
		
		virtual ~SimpleObserver() = default;
	
	private:
		std::function<void(T)> callback;
	};
	
	'''
	
	override protected subscription()'''
	template<class T>
	class subscription {
	protected:
		std::shared_ptr<std::reference_wrapper<Observer<T> > > observer;
	public:	
		subscription() «_noexcept» : observer(nullptr) {
		}
	
		subscription(Observer<T> &o)«_noexcept» :
					observer(std::make_shared<std::reference_wrapper<Observer<T> > >(o)) {
		}
	
		bool operator==(const subscription &other) const «_noexcept»{
			return observer == other.observer;
		}
		
		bool operator!=(const subscription &other) const «_noexcept» {
			return !(*this == other);
		}
		
		Observer<T> &operator*() const «_noexcept» {
			return observer->get();
		}
		
		Observer<T> *operator->() const «_noexcept» {
			return &(observer->get());
		}
		
		operator bool() const «_noexcept» {
			return observer.get() != nullptr;
		}
		
		virtual ~subscription() = default;
	};
	'''
	
	override protected observableBase()'''
	template<class T> class ObservableBase {
	public:
		ObservableBase()«_noexcept»
		{
		}
	
		bool subscribe(subscription<T> &s)«_noexcept» {
			if (s && std::find(this->subscriptions.begin(), this->subscriptions.end(), s) == this->subscriptions.end()) {
				this->subscriptions.push_back(s);
				return «TRUE_LITERAL»;
			}
			return «FALSE_LITERAL»;
		}
	
		bool unsubscribe(subscription<T> &s)«_noexcept» {
			if (!this->subscriptions.empty()) {
				auto old_end = this->subscriptions.end();
				this->subscriptions.erase(std::remove(this->subscriptions.begin(), this->subscriptions.end(), s), this->subscriptions.end());
				if(std::distance(old_end, this->subscriptions.end()) != 0){
					return «TRUE_LITERAL»;
				}
				return «FALSE_LITERAL»;
			}
			return «FALSE_LITERAL»;
		}
		
		virtual ~ObservableBase() = default;
	
	protected:
		std::vector<subscription<T>> subscriptions;
	
	};
	'''
	
	override protected observableT()'''
	template<class T>
	class Observable: public ObservableBase<T> {
	
	public:
	
		void next(T value) {
			for (auto sub = this->subscriptions.begin() ; sub != this->subscriptions.end(); ++sub){
				if (*sub) {
					(*sub)->next(value);
				}
			}
		}
		
		virtual ~Observable() = default;
	
	};
	'''
	
	override protected observableVoid()'''
	template<>
	class Observable<void> : public ObservableBase<void> {
	
	public:
		void next() {
			for (auto sub = this->subscriptions.begin() ; sub != this->subscriptions.end(); ++sub){
				if (*sub) {
					(*sub)->next();
				}
			}
		}
		
		virtual ~Observable() = default;
	
	};
	'''
}