package com.yakindu.sct.generator.cpp11.files

import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.files.TimerServiceSource
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class Cpp11TimerServiceSource extends TimerServiceSource {
	
	override content(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) '''
		«super.content(flow,entry,locations)»
		
		«unsetTimerRaw»
		
	'''
	
	def protected unsetTimerRaw()'''
	/*! Unset the given time event from the desctructor.
	 */
	void «timerServiceImplementation»::«unsetTimerRawFctID»(TimedInterface* statemachine_, «sc_eventid.fqName» event) {
		size_t prev_idx = length;
		size_t idx = next_active_task;
		
		while (idx < length) {
		    TimerTask &task = tasks[idx];
		
		    auto handle_ptr = task.data.get.time_event.handle.lock().get();
		    if (task.data.type == TimerTask::TaskData::TaskType::TIME_EVENT_TASK &&
		        handle_ptr == statemachine_ &&
		        task.data.get.time_event.pt_evid == event)
		    {
		        if (prev_idx == length) {
		            next_active_task = task.next_task_idx;
		        } else {
		            tasks[prev_idx].next_task_idx = task.next_task_idx;
		        }
		
		        task.next_task_idx = next_free_task;
		        next_free_task = idx;
		
		        task.data.get.time_event.handle.reset();
		
		        break;
		    }
		
		    prev_idx = idx;
		    idx = task.next_task_idx;
		}
	}
	'''
}