/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.generator.cpp.submodules.EventCode
import com.yakindu.sct.generator.cpp11.codemodel.EventQueueImplementation
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.stext.stext.StatechartScope

/**
 * The C++11 code relies on the code model so this implementation disables the base class code generation.
 * 
 * TODO:  Refactor to eliminate destructive override.
 * 
 * @author Axel Terfloth
 */
class Cpp11EventCode extends EventCode {
	
	@Inject protected extension EventQueueImplementation
	@Inject protected extension EventQueueExtension
		
	/** Deactivate base class event code contribution  */
	override generateEvents(ExecutionFlow it, StatechartScope scope) ''''''
	
	override eventNextCode(ExecutionFlow flow) {
		flow.activateNextEventCode
	}
	
	override getNextEventCode(ExecutionFlow it) {
		'''
		«dispatchEventMethod.name»(«nextEventMethod.name»())'''
	}
	
}