/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.submodules

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.generator.cpp.EventRaisingCode
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp11.codemodel.EventAccessors
import com.yakindu.sct.generator.cpp11.codemodel.EventEnum
import com.yakindu.sct.generator.cpp11.codemodel.EventInstanceClasses
import com.yakindu.sct.generator.cpp11.codemodel.EventQueueImplementation
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.EventDefinition
import java.util.ArrayList
import java.util.List
import com.yakindu.base.types.Event

/**
 * 
 * @author Axel Terfloth
 */
class Cpp11EventRaisingCode extends EventRaisingCode {

	@Inject protected extension EventQueue
	@Inject protected extension EventQueueExtension

	@Inject protected extension EventEnum
	@Inject protected extension EventInstanceClasses
	@Inject protected extension EventAccessors
	@Inject protected extension EventQueueImplementation
	@Inject protected extension Literals
	@Inject protected extension ITypeValueProvider
	@Inject protected extension ExpressionBuilder
	
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected GeneratorEntry entry

	override protected raiseLocalEventStatements(EventRaisingExpression it, CharSequence valueCode) {
		if (flow.isEventDriven)
			return #[ '''«flow.internalEventQueue.queueEventCode(null, event.definition as EventDefinition, if(valueCode!==null)valueCode.toString else "")»''']
		else
			return super.raiseLocalEventStatements(it, valueCode)
	}

	override protected List<CharSequence> raiseOutEventStatements(EventRaisingExpression it, CharSequence valueCode) {
		val statements = new ArrayList<CharSequence>()

		if (useOutEventGetters) {
			statements += setEventGetterFlag
			if(value !== null)
				statements += setEventValue(valueCode)
		}

		if (useOutEventObservables)
			statements += outEventObservable(valueCode)
			
		val localOutEvent = event.definition.event.getLocalOutEvent
		if (localOutEvent !== null)
			statements += '''«localOutEvent.asRaiser»(«IF value !== null»«value.code»«ENDIF»)'''

		return statements
	}
	
	def protected outEventObservable(EventRaisingExpression it, CharSequence valueCode){
		'''«event.definition.event.observableAccess».next(«IF useOutEventGetters && value !== null»«event.definition.event.valueAccess»«ELSEIF value !== null»«value.code»«ENDIF»)'''
	}
	
	override protected List<CharSequence> raiseDefaultEventStatements(EventRaisingExpression it, CharSequence valueCode) {
		if(flow.requiresIncomingEventQueue){
			val statements = new ArrayList<CharSequence>()
		
			statements += flow.incomingEventQueue.queueEventCode(null, event.definition as Event, if(valueCode!==null)valueCode.toString else "")
		
			return statements
		} else 
			super.raiseDefaultEventStatements(it, valueCode)				
	}

}
