/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.types

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppTypeSystemAccess
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.itemis.create.base.model.bindings.ReactiveModel
import com.yakindu.sct.model.sexec.concepts.SubMachine

/**
 * @author axel terfloth
 */
class Cpp11TypeSystemAccess extends CppTypeSystemAccess {
	
	@Inject protected extension StateEnum
	@Inject protected extension CppPointers
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected GeneratorEntry entry
	@Inject protected extension ReactiveModel	
	@Inject protected extension SubMachine	
	
	/**
	 * For C++11 a specific platform type is defined for the state enumeration. 
	 */
	override printStateEnumType(EnumerationType type) {
		return type.getOriginStatechart.stateEnum.asLiteral
	}
	
	override printStatechartType(ComplexType type) {
		if(entry.usePlainStatemachineRefPointers) super.printStatechartType(type)
		else {
			val namespace = type.getOriginStatechart.statechartNamespace
			sharedPtr + namespace.join("", "::", "::", [it]) + type.getOriginStatechart.module + pointerType
		} 
	}
	
	override printReferenceType(ComplexType type) {
		if(entry.useSmartPointers) {
			sharedPtr + type.asLiteral + pointerType
		}
		else {
			super.printReferenceType(type)
		} 
	}
	
	override dispatch String targetLanguageName(Type it, TypeSpecifier tspec) {
		switch (it) {
			case isBuiltInType: tspec.printBuiltInType
			default: cType
		}
	}
	
	override String printBuiltInType(TypeSpecifier it) {
		if (type.name == SHARED_POINTER) {
			return '''«sharedPtr»«getTargetLanguageName(typeArguments.head)»«pointerType»'''
		} else if (type.name == WEAK_POINTER) {
			return '''«weakPtr»«getTargetLanguageName(typeArguments.head)»«pointerType»'''
		} else if (type.name == UNIQUE_POINTER) {
			return '''«uniquePtr»«getTargetLanguageName(typeArguments.head)»«pointerType»'''
		} else super.printBuiltInType(it)
	}
	
	override isReferenceType(ComplexType it) {
		// TODO: the C++ generator decides based on the type if a members are integrated as pointers or as object.
		// this must be decided on the member (Property vs Part)
		if ( it.isObservableType || it.isObserverType || it.isSimpleObserverType /* || it.isSubmachineCtx */ ) return false
		super.isReferenceType(it)
	}
	
}